/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.sensors;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import java.util.Arrays;
import java.util.List;
import org.sonar.squid.entities.Resource;
import org.sonar.squid.sensors.BaseCommentsSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderCommentSensor
extends BaseCommentsSensor {
    @Override
    public List<Integer> getWantedTokens() {
        return Arrays.asList(16, 30, 14);
    }

    @Override
    public void visitToken(DetailAST ast) {
        Resource resource = this.peekResource();
        if (resource.getType() == Resource.Type.FILE && resource.getMeasures().getHeaderCommentLines() == 0) {
            resource.getMeasures().setHeaderCommentLines(this.calculateHeaderCommentsLines(ast.getType()));
        }
    }

    private int calculateHeaderCommentsLines(int tokenType) {
        TextBlock headerComment;
        boolean isJavadocComment;
        List headerBlock = (List)this.getFileContents().getCComments().get(1);
        if (headerBlock != null && !headerBlock.isEmpty() && ((isJavadocComment = (headerComment = (TextBlock)headerBlock.get(0)).getText()[0].startsWith("/**")) && tokenType == 16 || !isJavadocComment)) {
            BaseCommentsSensor.CommentLinesCounter counter = new BaseCommentsSensor.CommentLinesCounter();
            this.countCommentLines(headerComment, counter, null);
            return counter.getCommentsLines();
        }
        return 0;
    }
}

