/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;

import org.sonar.squid.entities.Resource;
import org.sonar.squid.handlers.Handler;
import org.sonar.squid.handlers.JavaCheckstyleHandler;
import org.sonar.squid.utils.FilesDiscovery;

public class Squid {

	private static boolean anaylsePropertyAccessors = false;

	public static void setAnaylsePropertyAccessors(boolean newAnaylsePropertyAccessors) {
		anaylsePropertyAccessors = newAnaylsePropertyAccessors;
	}

	public static Resource analyze(File dirOrFileToAnalyze) {
		return analyze(dirOrFileToAnalyze, Charset.defaultCharset());
	}

	public static Resource analyze(File dirOrFileToAnalyze, Handler handler) {
		return analyze(FilesDiscovery.traverse(dirOrFileToAnalyze), Charset.defaultCharset(), handler);
	}

	public static Resource analyze(File dirOrFileToAnalyze, Charset charset) {
		if (dirOrFileToAnalyze == null) {
			throw new IllegalStateException("There is no directory or file to analyse as the File object is null.");
		}
		return analyze(FilesDiscovery.traverse(dirOrFileToAnalyze), charset, new JavaCheckstyleHandler(
				anaylsePropertyAccessors));
	}

	public static Resource analyze(Collection<File> filesToAnalyse) {
		return analyze(filesToAnalyse, Charset.defaultCharset(), new JavaCheckstyleHandler(anaylsePropertyAccessors));
	}

	public static Resource analyze(Collection<File> filesToAnalyse, Charset charset) {
		return analyze(filesToAnalyse, charset, new JavaCheckstyleHandler(anaylsePropertyAccessors));
	}

	public static Resource analyze(Collection<File> filesToAnalyse, Charset charset, Handler handler) {
		Resource project = new Resource("Project", Resource.Type.PROJECT);
		handler.analyzeSources(project, filesToAnalyse, charset);
		return project;
	}

}
