/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.entities;

import java.util.Map;
import org.sonar.squid.entities.Resource;
import org.sonar.squid.utils.CountDistribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Measures {
    private Resource resource;
    private int methods = 0;
    private int attrAccessorMethods = 0;
    private int classes = 0;
    private int files = 0;
    private int packages = 0;
    private int loc = 0;
    private int ncloc = 0;
    private int blankLines = 0;
    private int statements = 0;
    private int branches = 0;
    private int complexity = 0;
    private int commentLines = 0;
    private int commentLinesOnLineOfCode = 0;
    private int blankCommentLines = 0;
    private int headerCommentLines = 0;
    private int publicApi = 0;
    private int publicDocumentedApi = 0;
    private int[] methodsComplexity = new int[0];
    private int[] classesComplexity = new int[0];

    public Measures(Resource resource) {
        this.resource = resource;
        if (resource.getType() == Resource.Type.PACKAGE) {
            ++this.packages;
        } else if (resource.getType() == Resource.Type.FILE) {
            ++this.files;
        } else if (resource.getType() == Resource.Type.CLASS) {
            ++this.classes;
        } else if (resource.getType() == Resource.Type.METHOD) {
            ++this.methods;
        }
    }

    public int[] getMethodsComplexity() {
        return this.methodsComplexity;
    }

    public Map<Integer, Integer> getMethodsComplexityDistribution(int ... distributionLimits) {
        return CountDistribution.count(distributionLimits, this.methodsComplexity);
    }

    public int[] getClassesComplexity() {
        return this.classesComplexity;
    }

    public Map<Integer, Integer> getClassesComplexityDistribution(int ... distributionLimits) {
        return CountDistribution.count(distributionLimits, this.classesComplexity);
    }

    public int getLoc() {
        return this.loc;
    }

    public int getNcloc() {
        if (this.ncloc == 0) {
            this.ncloc = this.getLoc() - this.getCommentLines() - this.getBlankLines() - this.getBlankCommentLines() + this.getCommentLinesOnLineOfCode();
        }
        return this.ncloc;
    }

    public void setNcloc(int ncloc) {
        this.ncloc = ncloc;
    }

    public int getBlankLines() {
        return this.blankLines;
    }

    public int getStatements() {
        return this.statements;
    }

    public void addStatement() {
        ++this.statements;
    }

    public int getCommentLines() {
        return this.commentLines;
    }

    public void setCommentLines(int commentLines) {
        this.commentLines = commentLines;
    }

    public int getCommentLinesOnLineOfCode() {
        return this.commentLinesOnLineOfCode;
    }

    public void setCommentLinesOnLineOfCode(int commentLinesOnLineOfCode) {
        this.commentLinesOnLineOfCode = commentLinesOnLineOfCode;
    }

    public int getRealCommentLines() {
        return this.commentLines - this.headerCommentLines;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void setComplexity(int complexity) {
        this.complexity = complexity;
        if (this.resource.getType() == Resource.Type.METHOD) {
            this.methodsComplexity = new int[]{complexity};
        } else if (this.resource.getType() == Resource.Type.CLASS) {
            this.classesComplexity = new int[]{complexity};
        }
    }

    public int getBranches() {
        return this.branches;
    }

    public void addBranch() {
        ++this.branches;
    }

    public void addPublicApi() {
        ++this.publicApi;
    }

    public void addPublicDocumentedApi() {
        ++this.publicDocumentedApi;
    }

    public int getMethods() {
        return this.methods;
    }

    public void setMethods(int methods) {
        this.methods = methods;
    }

    public int getClasses() {
        return this.classes;
    }

    public void setClasses(int classes) {
        this.classes = classes;
    }

    public int getFiles() {
        return this.files;
    }

    public int getPackages() {
        return this.packages;
    }

    public int getBlankCommentLines() {
        return this.blankCommentLines;
    }

    public void setBlankCommentLines(int blankCommentLines) {
        this.blankCommentLines = blankCommentLines;
    }

    private int[] addComplexity(int[] currentComplexity, int[] complexityToAdd) {
        if (complexityToAdd.length == 0) {
            return currentComplexity;
        }
        int[] added = new int[currentComplexity.length + complexityToAdd.length];
        System.arraycopy(currentComplexity, 0, added, 0, currentComplexity.length);
        System.arraycopy(complexityToAdd, 0, added, currentComplexity.length, complexityToAdd.length);
        return added;
    }

    protected void consolidate() {
        Measures childMeasures;
        for (Resource child : this.resource.getChildren()) {
            childMeasures = child.getMeasures();
            this.methods += childMeasures.getMethods();
            this.attrAccessorMethods += childMeasures.getAttrAccessorMethods();
            this.classes += childMeasures.getClasses();
            this.files += childMeasures.getFiles();
            this.packages += childMeasures.getPackages();
            this.blankLines += childMeasures.getBlankLines();
            this.loc += childMeasures.getLoc();
            this.ncloc += childMeasures.getNcloc();
            this.branches += childMeasures.getBranches();
            this.complexity += childMeasures.getComplexity();
            this.statements += childMeasures.getStatements();
            this.commentLines += childMeasures.getCommentLines();
            this.commentLinesOnLineOfCode += childMeasures.getCommentLinesOnLineOfCode();
            this.blankCommentLines += childMeasures.getBlankCommentLines();
            this.headerCommentLines += childMeasures.getHeaderCommentLines();
            this.publicApi += childMeasures.getPublicApi();
            this.publicDocumentedApi += childMeasures.getPublicDocumentedApi();
        }
        this.setComplexity(this.complexity);
        if (this.resource.getType() == Resource.Type.METHOD && this.isAttrAccessorMethod()) {
            this.publicApi = 0;
            this.publicDocumentedApi = 0;
            this.complexity = 0;
            this.methodsComplexity = new int[0];
            this.methods = 0;
        }
        for (Resource child : this.resource.getChildren()) {
            childMeasures = child.getMeasures();
            this.classesComplexity = this.addComplexity(this.classesComplexity, childMeasures.getClassesComplexity());
            this.methodsComplexity = this.addComplexity(this.methodsComplexity, childMeasures.getMethodsComplexity());
        }
    }

    public int getAttrAccessorMethods() {
        return this.attrAccessorMethods;
    }

    public void setAttrAccessorMethod() {
        this.attrAccessorMethods = 1;
    }

    public boolean isAttrAccessorMethod() {
        return this.attrAccessorMethods != 0;
    }

    public Measures setStatements(int statements) {
        this.statements = statements;
        return this;
    }

    public void setCommentsBlock(int commentLines, int blankCommentLines, int commentLinesOnLineOfCode) {
        this.commentLines = commentLines;
        this.blankCommentLines += blankCommentLines;
        this.commentLinesOnLineOfCode = commentLinesOnLineOfCode;
    }

    public int getHeaderCommentLines() {
        return this.headerCommentLines;
    }

    public void setHeaderCommentLines(int headerCommentLines) {
        this.headerCommentLines = headerCommentLines;
    }

    public void setFiles(int files) {
        this.files = files;
    }

    public void setPackages(int packages) {
        this.packages = packages;
    }

    public void setLoc(int loc) {
        this.loc = loc;
    }

    public void setBlankLines(int blankLines) {
        this.blankLines = blankLines;
    }

    public void setBranches(int branches) {
        this.branches = branches;
    }

    public int getPublicApi() {
        return this.publicApi;
    }

    public int getPublicDocumentedApi() {
        return this.publicDocumentedApi;
    }

    public double getPercentOfApiDoc() {
        return this.getPublicApi() != 0 ? (double)this.getPublicDocumentedApi() / (double)this.getPublicApi() : 0.0;
    }

    public double getPercentOfCommentLines() {
        if (this.loc != 0) {
            int comments = this.getRealCommentLines();
            return (double)comments / ((double)this.getNcloc() + (double)comments);
        }
        throw new IllegalStateException("Unable to compute the percentage of comment lines as 'loc' == 0");
    }

    public String toString() {
        return "loc=" + this.loc + ",ncloc=" + this.getNcloc() + ",cmp=" + this.complexity + ",stmts=" + this.statements + ",meth=" + this.methods + ",cla=" + this.classes;
    }
}

