/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.sensors;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.squid.sensors.ASTSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementSensor
extends ASTSensor {
    @Override
    public List<Integer> getWantedTokens() {
        return Arrays.asList(10, 43, 83, 92, 84, 85, 91, 89, 86, 87, 88, 90, 67, 96, 97, 28, 22, 93, 94, 151);
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.isCountable(ast)) {
            this.peekResource().getMeasures().addStatement();
        }
    }

    private boolean isCountable(DetailAST ast) {
        boolean countable = true;
        int tokenType = ast.getType();
        if (28 == tokenType) {
            countable = this.isExpressionCountable(ast);
        } else if (10 == tokenType) {
            countable = this.isVariableDefCountable(ast);
        }
        return countable;
    }

    private boolean isVariableDefCountable(DetailAST aAST) {
        int parentType;
        boolean countable = false;
        if (!(this.isClassVariable(aAST) || this.isInterfaceVariable(aAST) || 7 != (parentType = aAST.getParent().getType()) && 6 != parentType)) {
            DetailAST prevSibling = aAST.getPreviousSibling();
            countable = prevSibling == null || 74 != prevSibling.getType();
        }
        return countable;
    }

    private boolean isExpressionCountable(DetailAST aAST) {
        boolean countable;
        int parentType = aAST.getParent().getType();
        switch (parentType) {
            case 7: 
            case 22: 
            case 83: 
            case 84: 
            case 85: 
            case 91: 
            case 92: {
                DetailAST prevSibling = aAST.getPreviousSibling();
                countable = prevSibling == null || 76 != prevSibling.getType();
                break;
            }
            default: {
                countable = false;
            }
        }
        return countable;
    }
}

