/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.measures;

import java.util.EnumMap;
import java.util.Map;
import org.sonar.squid.measures.Metric;

public class Measures {
    private Map<Metric, Measure> measures = new EnumMap<Metric, Measure>(Metric.class);

    public double getValue(Metric metric) {
        Measure measure = this.measures.get((Object)metric);
        if (measure == null) {
            return 0.0;
        }
        return measure.getValue();
    }

    public Object getData(Metric metric) {
        Measure measure = this.measures.get((Object)metric);
        if (measure == null) {
            return null;
        }
        return measure.getData();
    }

    public void setValue(Metric metric, double measure) {
        this.getMeasureOrCreateIt(metric).setValue(measure);
    }

    public void setData(Metric metric, Object data) {
        this.getMeasureOrCreateIt(metric).setData(data);
    }

    private Measure getMeasureOrCreateIt(Metric metric) {
        Measure measure = this.measures.get((Object)metric);
        if (measure == null) {
            measure = new Measure(0.0);
            this.measures.put(metric, measure);
        }
        return measure;
    }

    public void removeMeasure(Metric metric) {
        this.measures.remove((Object)metric);
    }

    private static final class Measure {
        private double value;
        private Object data;

        private Measure(double value) {
            this.value = value;
        }

        private double getValue() {
            return this.value;
        }

        private void setValue(double value) {
            this.value = value;
        }

        private Object getData() {
            return this.data;
        }

        private void setData(Object data) {
            this.data = data;
        }
    }
}

