/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.ast.CheckstyleAuditListener;
import org.sonar.java.ast.CheckstyleSquidBridge;
import org.sonar.java.ast.visitor.AccessorVisitor;
import org.sonar.java.ast.visitor.AnonymousInnerClassVisitor;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.java.ast.visitor.BlankLinesVisitor;
import org.sonar.java.ast.visitor.BranchVisitor;
import org.sonar.java.ast.visitor.ClassVisitor;
import org.sonar.java.ast.visitor.CommentVisitor;
import org.sonar.java.ast.visitor.ComplexityVisitor;
import org.sonar.java.ast.visitor.EndAtLineVisitor;
import org.sonar.java.ast.visitor.FileVisitor;
import org.sonar.java.ast.visitor.LinesOfCodeVisitor;
import org.sonar.java.ast.visitor.LinesVisitor;
import org.sonar.java.ast.visitor.MethodVisitor;
import org.sonar.java.ast.visitor.PackageVisitor;
import org.sonar.java.ast.visitor.PublicApiVisitor;
import org.sonar.java.ast.visitor.StatementVisitor;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SquidConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAstScanner
extends CodeScanner<AstVisitor> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaAstScanner.class);
    private SquidConfiguration conf;
    private SourceCode project;

    public JavaAstScanner(SquidConfiguration conf, SourceCode project) {
        this.conf = conf;
        this.project = project;
    }

    private void launchCheckstyleEngine(Collection<File> files, Charset charset) {
        Checker c = this.createChecker(charset);
        File[] processedFiles = new File[files.size()];
        files.toArray(processedFiles);
        c.process(processedFiles);
        c.destroy();
    }

    private Checker createChecker(Charset charset) {
        try {
            InputStream checkstyleConfig = JavaAstScanner.class.getClassLoader().getResourceAsStream("checkstyle-configuration.xml");
            String readenConfig = IOUtils.toString((InputStream)checkstyleConfig);
            readenConfig = readenConfig.replace("${charset}", charset.toString());
            checkstyleConfig = new ByteArrayInputStream(readenConfig.getBytes());
            Configuration config = ConfigurationLoader.loadConfiguration((InputStream)checkstyleConfig, (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
            Checker c = new Checker();
            c.configure(config);
            c.addListener((AuditListener)new CheckstyleAuditListener());
            return c;
        }
        catch (Exception e) {
            throw new AnalysisException("Unable to create Checkstyle Checker object with 'checkstyle-configuration.xml' as Checkstyle configuration file name", e);
        }
    }

    public JavaAstScanner scanDirectory(File javaSourceDirectory) {
        Collection files = FileUtils.listFiles((File)javaSourceDirectory, (IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)FileFilterUtils.directoryFileFilter());
        return this.scanFiles(files);
    }

    public JavaAstScanner scanFile(File javaFile) {
        return this.scanFiles(Arrays.asList(javaFile));
    }

    public JavaAstScanner scanFiles(Collection<File> javaFiles) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("----- Java sources analyzed by Squid:");
            for (File javaFile : javaFiles) {
                LOG.debug(javaFile.getAbsolutePath());
            }
            LOG.debug("-----");
        }
        Stack<SourceCode> resourcesStack = new Stack<SourceCode>();
        resourcesStack.add(this.project);
        for (AstVisitor visitor : this.getVisitors()) {
            visitor.setResourcesStack(resourcesStack);
        }
        CheckstyleSquidBridge.setASTVisitors(this.getVisitors());
        CheckstyleSquidBridge.setSquidConfiguration(this.conf);
        this.launchCheckstyleEngine(javaFiles, this.conf.getCharset());
        return this;
    }

    @Override
    public Collection<Class<? extends AstVisitor>> getVisitorClasses() {
        ArrayList<Class<? extends AstVisitor>> visitorClasses = new ArrayList<Class<? extends AstVisitor>>();
        visitorClasses.add(PackageVisitor.class);
        visitorClasses.add(FileVisitor.class);
        visitorClasses.add(ClassVisitor.class);
        visitorClasses.add(AnonymousInnerClassVisitor.class);
        visitorClasses.add(MethodVisitor.class);
        visitorClasses.add(EndAtLineVisitor.class);
        visitorClasses.add(LinesVisitor.class);
        visitorClasses.add(BlankLinesVisitor.class);
        visitorClasses.add(CommentVisitor.class);
        visitorClasses.add(PublicApiVisitor.class);
        visitorClasses.add(BranchVisitor.class);
        visitorClasses.add(StatementVisitor.class);
        if (this.conf.isAnalysePropertyAccessors()) {
            visitorClasses.add(AccessorVisitor.class);
        }
        visitorClasses.add(ComplexityVisitor.class);
        visitorClasses.add(LinesOfCodeVisitor.class);
        return visitorClasses;
    }
}

