/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVisitor
extends AstVisitor {
    private static final List<Integer> wantedTokens = Arrays.asList(14, 15, 154, 157);

    @Override
    public List<Integer> getWantedTokens() {
        return wantedTokens;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String className = ast.findFirstToken(58).getText();
        SourceClass unit = this.peekResource().isType(SourceClass.class) ? ClassVisitor.createSourceClass((SourceClass)this.peekResource(), className) : ClassVisitor.createSourceClass(this.peekParentPackage(), className);
        this.addResource(unit);
        unit.setStartAtLine(ast.getLineNo());
        unit.setMeasure(Metric.CLASSES, 1);
        if (this.isInterface(ast.getType())) {
            unit.setMeasure(Metric.INTERFACES, 1);
        }
        if (this.isAbstract(ast)) {
            unit.setMeasure(Metric.ABSTRACT_CLASSES, 1);
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        this.popResource();
    }

    private boolean isAbstract(DetailAST ast) {
        DetailAST abstractAST = ast.findFirstToken(5).findFirstToken(40);
        return abstractAST != null;
    }

    private boolean isInterface(int type) {
        return type == 15;
    }

    static SourceClass createSourceClass(SourcePackage parentPackage, String className) {
        StringBuilder key = new StringBuilder();
        if (parentPackage != null && !parentPackage.getKey().equals("")) {
            key.append(parentPackage.getKey());
            key.append("/");
        }
        key.append(className);
        return new SourceClass(key.toString(), className);
    }

    static SourceClass createSourceClass(SourceClass parentClass, String innerClassName) {
        return new SourceClass(parentClass.getKey() + "$" + innerClassName, innerClassName);
    }
}

