/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.measures.Metric;

public class FileVisitor
extends AstVisitor {
    public void visitFile(DetailAST ast) {
        String fileName = FileVisitor.extractFileNameFromFilePath(this.getFileContents().getFilename());
        SourceFile sourceFile = FileVisitor.createSourceFile(this.peekParentPackage(), fileName);
        sourceFile.setMeasure(Metric.FILES, 1);
        this.addResource(sourceFile);
    }

    public void leaveFile(DetailAST ast) {
        this.popResource();
    }

    static String extractFileNameFromFilePath(String filePath) {
        int lastIndexOfSlashOrBackSlashChar = filePath.lastIndexOf(47);
        if (lastIndexOfSlashOrBackSlashChar != -1) {
            return filePath.substring(lastIndexOfSlashOrBackSlashChar + 1);
        }
        lastIndexOfSlashOrBackSlashChar = filePath.lastIndexOf(92);
        if (lastIndexOfSlashOrBackSlashChar != -1) {
            return filePath.substring(lastIndexOfSlashOrBackSlashChar + 1);
        }
        return filePath;
    }

    static SourceFile createSourceFile(SourcePackage parentPackage, String fileName) {
        StringBuilder key = new StringBuilder();
        if (parentPackage != null && !parentPackage.getKey().equals("")) {
            key.append(parentPackage.getKey());
            key.append("/");
        }
        key.append(fileName);
        return new SourceFile(key.toString(), fileName);
    }
}

