/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.indexer.SquidIndex;

public class AccessorVisitor
extends BytecodeVisitor {
    private AsmClass asmClass;

    public AccessorVisitor(SquidIndex index) {
        super(index);
    }

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        String propertyName = this.extractPropertyNameFromMethodName(asmMethod);
        if (propertyName != null && this.asmClass.getField(propertyName) != null) {
            asmMethod.setAccessor(true);
        }
    }

    private String extractPropertyNameFromMethodName(AsmMethod asmMethod) {
        String propertyName;
        String methodName = asmMethod.getName();
        if (methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set"))) {
            propertyName = methodName.substring(3);
        } else if (methodName.length() > 2 && methodName.startsWith("is")) {
            propertyName = methodName.substring(2);
        } else {
            return null;
        }
        byte[] bytes = propertyName.getBytes();
        bytes[0] = (byte)Character.toLowerCase((char)bytes[0]);
        return new String(bytes);
    }
}

