/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.java.recognizer.JavaFootprint;
import org.sonar.squid.api.SquidConfiguration;
import org.sonar.squid.recognizer.CodeRecognizer;
import org.sonar.squid.text.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckstyleSquidBridge
extends Check {
    private static Logger logger = LoggerFactory.getLogger(CheckstyleSquidBridge.class);
    private static AstVisitor[] visitors;
    private static int[] allTokens;
    private static CodeRecognizer codeRecognizer;

    static void setASTVisitors(List<AstVisitor> visitors) {
        CheckstyleSquidBridge.visitors = visitors.toArray(new AstVisitor[visitors.size()]);
        TreeSet<Integer> sorter = new TreeSet<Integer>();
        for (AstVisitor visitor : visitors) {
            sorter.addAll(visitor.getWantedTokens());
            allTokens = new int[sorter.size()];
            int i = 0;
            for (Integer itSorted : sorter) {
                CheckstyleSquidBridge.allTokens[i++] = itSorted;
            }
        }
    }

    static void setSquidConfiguration(SquidConfiguration conf) {
        codeRecognizer = new CodeRecognizer(conf.getCommentedCodeThreshold(), new JavaFootprint());
    }

    public int[] getDefaultTokens() {
        return allTokens;
    }

    public void beginTree(DetailAST ast) {
        try {
            Source source = this.createSource();
            for (AstVisitor visitor : visitors) {
                visitor.setFileContents(this.getFileContents());
                visitor.setSource(source);
                visitor.visitFile(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    private Source createSource() {
        return new Source(this.getFileContents().getLines(), codeRecognizer);
    }

    public void visitToken(DetailAST ast) {
        try {
            for (AstVisitor visitor : visitors) {
                if (!visitor.getWantedTokens().contains(ast.getType())) continue;
                visitor.visitToken(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    public void leaveToken(DetailAST ast) {
        try {
            for (int i = visitors.length - 1; i >= 0; --i) {
                AstVisitor visitor = visitors[i];
                if (!visitor.getWantedTokens().contains(ast.getType())) continue;
                visitor.leaveToken(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    public void finishTree(DetailAST ast) {
        try {
            for (int i = visitors.length - 1; i >= 0; --i) {
                AstVisitor visitor = visitors[i];
                visitor.leaveFile(ast);
            }
        }
        catch (RuntimeException e) {
            this.logAndThrowException(e);
        }
    }

    private void logAndThrowException(RuntimeException e) {
        logger.error("Squid Error occurs when analysing :" + this.getFileContents().getFilename(), (Throwable)e);
        throw e;
    }
}

