/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentVisitor
extends AstVisitor {
    private static final List<Integer> wantedTokens = Arrays.asList(73);

    @Override
    public List<Integer> getWantedTokens() {
        return wantedTokens;
    }

    @Override
    public void visitToken(DetailAST ast) {
        int startAtLine = this.peekResource().getStartAtLine();
        int endAtLine = this.peekResource().getEndAtLine();
        this.peekResource().setMeasure(Metric.COMMENTED_OUT_CODE_LINES, this.getSource().getMeasure(Metric.COMMENTED_OUT_CODE_LINES, startAtLine, endAtLine));
        this.peekResource().setMeasure(Metric.COMMENT_LINES, this.getSource().getMeasure(Metric.COMMENT_LINES, startAtLine, endAtLine));
        this.peekResource().setMeasure(Metric.COMMENT_BLANK_LINES, this.getSource().getMeasure(Metric.COMMENT_BLANK_LINES, startAtLine, endAtLine));
    }

    @Override
    public void visitFile(DetailAST ast) {
        SourceFile file = (SourceFile)this.peekResource();
        file.addNoSonarTagLines(this.getSource().getNoSonarTagLines());
        file.setMeasure(Metric.HEADER_COMMENT_LINES, this.getSource().getMeasure(Metric.HEADER_COMMENT_LINES));
        file.setMeasure(Metric.COMMENTED_OUT_CODE_LINES, this.getSource().getMeasure(Metric.COMMENTED_OUT_CODE_LINES));
        file.setMeasure(Metric.COMMENT_LINES, this.getSource().getMeasure(Metric.COMMENT_LINES));
        file.setMeasure(Metric.COMMENT_BLANK_LINES, this.getSource().getMeasure(Metric.COMMENT_BLANK_LINES));
    }
}

