/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.List;
import org.sonar.java.ast.visitor.AstUtils;
import org.sonar.java.ast.visitor.AstVisitor;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementVisitor
extends AstVisitor {
    private static final List<Integer> WANTED_TOKENS = Arrays.asList(10, 43, 83, 92, 84, 85, 91, 89, 86, 87, 88, 90, 67, 96, 97, 28, 22, 93, 94, 151);

    @Override
    public List<Integer> getWantedTokens() {
        return WANTED_TOKENS;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.isCountable(ast)) {
            this.peekResource().add(Metric.STATEMENTS, 1.0);
        }
    }

    private boolean isCountable(DetailAST ast) {
        boolean countable = true;
        int tokenType = ast.getType();
        if (28 == tokenType) {
            countable = this.isExpressionCountable(ast);
        } else if (10 == tokenType) {
            countable = this.isVariableDefCountable(ast);
        }
        return countable;
    }

    private boolean isVariableDefCountable(DetailAST aAST) {
        int parentType;
        boolean countable = false;
        if (!(AstUtils.isClassVariable(aAST) || AstUtils.isInterfaceVariable(aAST) || 7 != (parentType = aAST.getParent().getType()) && 6 != parentType)) {
            DetailAST prevSibling = aAST.getPreviousSibling();
            countable = prevSibling == null || 74 != prevSibling.getType();
        }
        return countable;
    }

    private boolean isExpressionCountable(DetailAST aAST) {
        boolean countable;
        int parentType = aAST.getParent().getType();
        switch (parentType) {
            case 7: 
            case 22: 
            case 83: 
            case 84: 
            case 85: 
            case 91: 
            case 92: {
                DetailAST prevSibling = aAST.getPreviousSibling();
                countable = prevSibling == null || 76 != prevSibling.getType();
                break;
            }
            default: {
                countable = false;
            }
        }
        return countable;
    }
}

