/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import org.objectweb.asm.Type;

public final class AsmType {
    private AsmType() {
    }

    public static boolean isArray(Type type) {
        return type.getSort() == 9;
    }

    public static boolean isObject(Type type) {
        return type.getSort() == 10;
    }

    public static boolean isArrayOfObject(Type type) {
        return AsmType.isArray(type) && type.getElementType().getSort() == 10;
    }

    public static boolean containsObject(Type type) {
        return AsmType.isObject(type) || AsmType.isArrayOfObject(type);
    }

    public static boolean isVoid(Type type) {
        return type == Type.VOID_TYPE;
    }

    public static String getObjectInternalName(Type type) {
        if (AsmType.isObject(type)) {
            return type.getInternalName();
        }
        if (AsmType.isArrayOfObject(type)) {
            return type.getElementType().getInternalName();
        }
        throw new IllegalStateException("This method should not be called on a descriptor whitout Object reference : " + type.getDescriptor());
    }
}

