/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.api;

import java.nio.charset.Charset;

public class SquidConfiguration {
    private boolean analysePropertyAccessors = true;
    private Charset charset = Charset.defaultCharset();
    private static final double COMMENTED_CODE_DEFAULT_THRESHOLD = 0.9;
    private double commentedCodeThreshold = 0.9;

    public SquidConfiguration() {
    }

    public SquidConfiguration(boolean analysePropertyAccessors) {
        this.analysePropertyAccessors = analysePropertyAccessors;
    }

    public SquidConfiguration(double commentedCodeThreshold) {
        this.setCommentedCodeThreshold(commentedCodeThreshold);
    }

    public SquidConfiguration(boolean analysePropertyAccessors, Charset charset) {
        this.analysePropertyAccessors = analysePropertyAccessors;
        this.charset = charset;
    }

    public SquidConfiguration(boolean analysePropertyAccessors, Charset charset, double commentedCodeThreshold) {
        this.analysePropertyAccessors = analysePropertyAccessors;
        this.charset = charset;
        this.setCommentedCodeThreshold(commentedCodeThreshold);
    }

    public boolean isAnalysePropertyAccessors() {
        return this.analysePropertyAccessors;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private void setCommentedCodeThreshold(double commentedCodeThreshold) {
        if (commentedCodeThreshold < 0.0 || commentedCodeThreshold > 1.0) {
            throw new IllegalArgumentException("Commented Code Threshold should be between [0...1]. Current value : " + commentedCodeThreshold);
        }
        this.commentedCodeThreshold = commentedCodeThreshold;
    }

    public double getCommentedCodeThreshold() {
        return this.commentedCodeThreshold;
    }
}

