/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import java.util.Arrays;
import java.util.List;
import org.sonar.java.ast.visitor.AstUtils;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorVisitor
extends JavaAstVisitor {
    private static final List<Integer> TOKENS = Arrays.asList(9);

    @Override
    public List<Integer> getWantedTokens() {
        return TOKENS;
    }

    @Override
    public void visitToken(DetailAST methodAst) {
        SourceCode currentMethod = this.peekSourceCode();
        AstUtils.ensureResourceType(currentMethod, SourceMethod.class);
        Scope methodScope = AstUtils.getScope(methodAst);
        if (AstUtils.isScope(methodScope, Scope.PUBLIC) && this.isAccessor(methodAst, currentMethod.getName())) {
            currentMethod.setMeasure((MetricDef)Metric.ACCESSORS, 1);
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        SourceMethod currentMethod = (SourceMethod)this.peekSourceCode();
        if (currentMethod.isAccessor()) {
            currentMethod.setMeasure((MetricDef)Metric.PUBLIC_API, 0);
            currentMethod.setMeasure((MetricDef)Metric.PUBLIC_DOC_API, 0);
            currentMethod.setMeasure((MetricDef)Metric.METHODS, 0);
            currentMethod.setMeasure((MetricDef)Metric.COMPLEXITY, 0);
        }
    }

    private boolean isAccessor(DetailAST methodAst, String methodName) {
        boolean methodWithoutParams = this.isMethodWithoutParameters(methodAst);
        return this.isValidGetter(methodAst, methodName, methodWithoutParams) || this.isValidSetter(methodAst, methodName, methodWithoutParams) || this.isValidBooleanGetter(methodAst, methodName, methodWithoutParams);
    }

    private boolean isMethodWithoutParameters(DetailAST methodAst) {
        return methodAst.findFirstToken(20).getChildCount() == 0;
    }

    private boolean isValidBooleanGetter(DetailAST method, String methodName, boolean methodWithoutParams) {
        AST type;
        if (methodName.startsWith("is") && methodWithoutParams && this.isAstType(type = AstUtils.findType(method), 50)) {
            return this.isValidGetter(method, methodName.replace("is", "get"), methodWithoutParams);
        }
        return false;
    }

    private boolean isValidSetter(DetailAST method, String methodName, boolean methodWithoutParams) {
        DetailAST methodBody;
        DetailAST methodParams;
        AST type;
        if (methodName.startsWith("set") && !methodWithoutParams && this.isVoidMethodReturn(type = AstUtils.findType(method)) && (methodParams = method.findFirstToken(20)).getChildCount(21) == 1 && this.isAstType((AST)(methodBody = method.getLastChild()), 7) && methodBody.getChildCount() == 3) {
            return this.inspectSetterMethodBody(method, methodParams, methodBody);
        }
        return false;
    }

    private boolean isValidGetter(DetailAST method, String methodName, boolean methodWithoutParams) {
        DetailAST methodBody;
        AST type;
        if (methodName.startsWith("get") && methodWithoutParams && !this.isVoidMethodReturn(type = AstUtils.findType(method)) && this.isAstType((AST)(methodBody = method.getLastChild()), 7) && methodBody.getChildCount() == 2) {
            return this.inspectGetterMethodBody(method, methodBody);
        }
        return false;
    }

    private boolean inspectGetterMethodBody(DetailAST method, DetailAST methodBody) {
        AST varReturned;
        AST expr;
        AST returnAST = methodBody.getFirstChild();
        if (this.isAstType(returnAST, 88) && this.isAstType(expr = returnAST.getFirstChild(), 28) && this.isAstType(expr.getNextSibling(), 45) && this.isAstType(varReturned = expr.getFirstChild(), 58)) {
            return this.findPrivateClassVariable(method, varReturned.getText());
        }
        return false;
    }

    private boolean inspectSetterMethodBody(DetailAST method, DetailAST methodParams, DetailAST methodBody) {
        DetailAST assignment;
        DetailAST expr = (DetailAST)methodBody.getFirstChild();
        if (this.isAstType((AST)expr, 28) && (assignment = expr.findFirstToken(80)) != null) {
            DetailAST dotAst = assignment.findFirstToken(59);
            DetailAST varAssigned = assignment.getLastChild();
            DetailAST varAssignedMethodParam = methodParams.findFirstToken(21).findFirstToken(58);
            if (this.isAstType((AST)varAssigned, 58) && varAssigned.getText().equals(varAssignedMethodParam.getText())) {
                DetailAST varToAssign = dotAst != null ? dotAst.findFirstToken(58) : assignment.findFirstToken(58);
                return this.findPrivateClassVariable(method, varToAssign.getText());
            }
        }
        return false;
    }

    private boolean findPrivateClassVariable(DetailAST method, String varName) {
        DetailAST objBlock = AstUtils.findParent(method, 6);
        for (AST i = objBlock.getFirstChild(); i != null; i = i.getNextSibling()) {
            DetailAST varDef;
            if (!this.isAstType(i, 10) || !AstUtils.isScope(AstUtils.getScope(varDef = (DetailAST)i), Scope.PRIVATE) || !varDef.findFirstToken(58).getText().equals(varName)) continue;
            return true;
        }
        return false;
    }

    private boolean isVoidMethodReturn(AST type) {
        return this.isAstType(type, 49);
    }

    private boolean isAstType(AST ast, int type) {
        return ast.getType() == type;
    }
}

