/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmClassProvider;
import org.sonar.java.bytecode.asm.AsmClassVisitor;

public class AsmClassProviderImpl
extends AsmClassProvider {
    private static Logger logger = LoggerFactory.getLogger(AsmClassProviderImpl.class);
    private final ClassLoader classLoader;
    private Map<String, AsmClass> asmClassCache = new HashMap<String, AsmClass>();

    public AsmClassProviderImpl() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public AsmClassProviderImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public AsmClass getClass(String internalName, AsmClassProvider.DETAIL_LEVEL level) {
        if (internalName == null) {
            throw new IllegalStateException("You can try to load a class whose internalName = 'null'");
        }
        AsmClass asmClass = this.getAsmClassFromCacheOrCreateIt(internalName);
        if (level.isGreaterThan(asmClass.getDetailLevel())) {
            this.decoracteAsmClassFromBytecode(asmClass, level);
        }
        return asmClass;
    }

    private AsmClass getAsmClassFromCacheOrCreateIt(String internalName) {
        AsmClass asmClass = this.asmClassCache.get(internalName);
        if (asmClass == null) {
            asmClass = new AsmClass(internalName, AsmClassProvider.DETAIL_LEVEL.NOTHING);
            this.asmClassCache.put(internalName, asmClass);
        }
        return asmClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decoracteAsmClassFromBytecode(AsmClass asmClass, AsmClassProvider.DETAIL_LEVEL level) {
        InputStream input = null;
        try {
            AsmClassVisitor classVisitor = new AsmClassVisitor(this, asmClass, level);
            input = this.classLoader.getResourceAsStream(asmClass.getInternalName() + ".class");
            ClassReader asmReader = new ClassReader(input);
            asmReader.accept((ClassVisitor)classVisitor, 0);
            IOUtils.closeQuietly((InputStream)input);
        }
        catch (IOException e) {
            logger.warn("Class '" + asmClass.getInternalName() + "' is not accessible through the ClassLoader.");
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }
}

