/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.squid.api;

import org.sonar.check.Message;

import java.text.MessageFormat;

public class CheckMessage implements Message {

  private int line;
  private SourceCode sourceCode;
  private CodeCheck codeCheck;
  private String defaultMessage;
  private Object[] messageArguments;

  public CheckMessage(CodeCheck rule, String message, Object... messageArguments) {
    this.codeCheck = rule;
    this.defaultMessage = message;
    this.messageArguments = messageArguments;
  }

  public void setSourceCode(SourceCode sourceCode) {
    this.sourceCode = sourceCode;
  }

  public SourceCode getSourceCode() {
    return sourceCode;
  }

  public void setLine(int line) {
    this.line = line;
  }

  public int getLine() {
    return line;
  }

  public CodeCheck getCheck() {
    return codeCheck;
  }

  public String getDefaultMessage() {
    return defaultMessage;
  }

  public Object[] getMessageArguments() {
    return messageArguments;
  }

  public String formatDefaultMessage() {
    return MessageFormat.format(defaultMessage, messageArguments);
  }
}
