/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.sonar.java.bytecode.BytecodeVisitorNotifier;
import org.sonar.java.bytecode.ClassworldsClassLoader;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmClassProvider;
import org.sonar.java.bytecode.asm.AsmClassProviderImpl;
import org.sonar.java.bytecode.visitor.AccessorVisitor;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.bytecode.visitor.DITVisitor;
import org.sonar.java.bytecode.visitor.DeadCodeDetectionVisitor;
import org.sonar.java.bytecode.visitor.DependenciesVisitor;
import org.sonar.java.bytecode.visitor.LCOM4Visitor;
import org.sonar.java.bytecode.visitor.NOCVisitor;
import org.sonar.java.bytecode.visitor.RFCVisitor;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.indexer.SquidIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeScanner
extends CodeScanner<BytecodeVisitor> {
    private SquidIndex indexer;

    public BytecodeScanner(SquidIndex indexer) {
        this.indexer = indexer;
    }

    public BytecodeScanner scan(Collection<File> bytecodeFilesOrDirectories) {
        Collection<SourceCode> classes = this.indexer.search(new QueryByType(SourceClass.class));
        return this.scan(classes, new AsmClassProviderImpl(ClassworldsClassLoader.create(bytecodeFilesOrDirectories)));
    }

    public BytecodeScanner scanDirectory(File bytecodeDirectory) {
        return this.scan(Arrays.asList(bytecodeDirectory));
    }

    protected BytecodeScanner scan(Collection<SourceCode> classes, AsmClassProvider classProvider) {
        this.loadByteCodeInformation(classes, classProvider);
        this.notifyBytecodeVisitors(classes, classProvider);
        return this;
    }

    private void notifyBytecodeVisitors(Collection<SourceCode> classes, AsmClassProvider classProvider) {
        BytecodeVisitor[] visitorArray = this.getVisitors().toArray(new BytecodeVisitor[this.getVisitors().size()]);
        for (SourceCode sourceCode : classes) {
            AsmClass asmClass = classProvider.getClass(sourceCode.getKey(), AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
            BytecodeVisitorNotifier visitorNotifier = new BytecodeVisitorNotifier(asmClass, visitorArray);
            visitorNotifier.notifyVisitors();
        }
    }

    private void loadByteCodeInformation(Collection<SourceCode> classes, AsmClassProvider classProvider) {
        for (SourceCode sourceCode : classes) {
            classProvider.getClass(sourceCode.getKey(), AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
        }
    }

    @Override
    public Collection<Class<? extends BytecodeVisitor>> getVisitorClasses() {
        ArrayList<Class<? extends BytecodeVisitor>> visitorClasses = new ArrayList<Class<? extends BytecodeVisitor>>();
        visitorClasses.add(AccessorVisitor.class);
        visitorClasses.add(DITVisitor.class);
        visitorClasses.add(RFCVisitor.class);
        visitorClasses.add(NOCVisitor.class);
        visitorClasses.add(LCOM4Visitor.class);
        visitorClasses.add(DependenciesVisitor.class);
        visitorClasses.add(DeadCodeDetectionVisitor.class);
        return visitorClasses;
    }
}

