/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.java.bytecode.asm.AsmAccessFlags;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.squid.api.SourceCodeEdgeUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmResource {
    private int accessFlags;
    AsmClass parent;
    boolean touched = false;
    private List<AsmEdge> outgoingEdges = new ArrayList<AsmEdge>();

    void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    void addUsesOfClasses(AsmClass[] asmClasses) {
        for (AsmClass asmClass : asmClasses) {
            this.addEdge(new AsmEdge(this, asmClass, SourceCodeEdgeUsage.USES));
        }
    }

    public Set<AsmClass> getDistinctUsedAsmClasses() {
        HashSet<AsmClass> distinctUsedAsmClasses = new HashSet<AsmClass>();
        for (AsmEdge usage : this.getOutgoingEdges()) {
            if (usage.getUsage() != SourceCodeEdgeUsage.USES) continue;
            distinctUsedAsmClasses.add((AsmClass)usage.getTo());
        }
        return distinctUsedAsmClasses;
    }

    public Set<AsmClass> getImplementedInterfaces() {
        HashSet<AsmClass> implementedInterfaces = new HashSet<AsmClass>();
        for (AsmEdge usage : this.getOutgoingEdges()) {
            if (usage.getUsage() != SourceCodeEdgeUsage.IMPLEMENTS) continue;
            implementedInterfaces.add((AsmClass)usage.getTo());
        }
        return implementedInterfaces;
    }

    public void addEdge(AsmEdge edge) {
        this.outgoingEdges.add(edge);
    }

    public Collection<AsmEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public AsmClass getParent() {
        return this.parent;
    }

    public boolean isAbstract() {
        return AsmAccessFlags.isAbstract(this.accessFlags);
    }

    public boolean isInterface() {
        return AsmAccessFlags.isInterface(this.accessFlags);
    }

    public boolean isStatic() {
        return AsmAccessFlags.isStatic(this.accessFlags);
    }

    boolean isPublic() {
        return AsmAccessFlags.isPublic(this.accessFlags);
    }

    boolean isPrivate() {
        return AsmAccessFlags.isPrivate(this.accessFlags);
    }

    boolean isFinal() {
        return AsmAccessFlags.isFinal(this.accessFlags);
    }

    public boolean isDeprecated() {
        return AsmAccessFlags.isDeprecated(this.accessFlags);
    }

    void setTouched(boolean touched) {
        this.touched = touched;
    }

    public boolean isTouched() {
        return this.touched;
    }
}

