/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import org.sonar.check.BelongsToProfile;
import org.sonar.check.Check;
import org.sonar.check.IsoCategory;
import org.sonar.check.Priority;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.indexer.SquidIndex;

@Check(key="SQUID.CallToDeprecatedMethod", title="Avoid use of deprecated method.", isoCategory=IsoCategory.Portability, priority=Priority.MINOR, languages={"java"}, description="<p>Once deprecated, a method should no longer be used as it means that the method might be removed sooner or later.</p>")
@BelongsToProfile(title="Sonar Cobol Way", priority=Priority.MAJOR)
public class CallToDeprecatedMethodVisitor
extends BytecodeVisitor
implements CodeCheck {
    private AsmClass asmClass;

    public CallToDeprecatedMethodVisitor(SquidIndex index) {
        super(index);
    }

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitEdge(AsmEdge edge) {
        if (edge.getTo().isDeprecated() && edge.getTo() instanceof AsmMethod) {
            SourceFile sourceFile = this.getSourceFile(this.asmClass);
            CheckMessage message = new CheckMessage(this, "Avoid use of deprecated method.", new Object[0]);
            message.setLine(edge.getSourceLineNumber());
            sourceFile.log(message);
        }
    }

    public String getKey() {
        return this.getClass().getSimpleName();
    }
}

