/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.indexer.SquidIndex;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public class DITVisitor
extends BytecodeVisitor {
    public DITVisitor(SquidIndex index) {
        super(index);
    }

    public void visitClass(AsmClass asmClass) {
        int dit = this.calculateDepthOfInheritance(asmClass);
        this.getSourceClass(asmClass).add((MetricDef)Metric.DIT, dit);
        if (this.isMainPublicClassInFile(asmClass)) {
            this.getSourceFile(asmClass).add((MetricDef)Metric.DIT, dit);
        }
    }

    private int calculateDepthOfInheritance(AsmClass asmClass) {
        int dit = 0;
        for (AsmClass superClass = asmClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
            ++dit;
        }
        return dit;
    }
}

