/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.check;

import org.sonar.check.Check;
import org.sonar.check.IsoCategory;
import org.sonar.check.Priority;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.check.BytecodeCheck;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

@Check(key="UnusedProtectedMethod", title="Unused protected method", isoCategory=IsoCategory.Maintainability, priority=Priority.MAJOR, description="<p>Deleting dead code helps to reduce cost of maintenance and to improve quality of code. As a side effect it also improves code coverage metrics by deleting code that can't be tested.</p>")
public class UnusedProtectedMethodCheck
extends BytecodeCheck {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (!asmMethod.isUsed() && asmMethod.isProtected()) {
            CheckMessage message = new CheckMessage(this, "Protected method '" + asmMethod.getName() + "(...)' is never used.", new Object[0]);
            SourceMethod sourceMethod = this.getSourceMethod(asmMethod);
            if (sourceMethod != null) {
                message.setLine(sourceMethod.getStartAtLine());
            }
            SourceFile file = this.getSourceFile(this.asmClass);
            file.log(message);
        }
    }
}

