/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import java.util.HashSet;
import java.util.Set;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.SourceCodeEdgeUsage;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public class RFCVisitor
extends BytecodeVisitor {
    private AsmClass asmClass;
    private Set<AsmMethod> distinctCallToExternalMethods;
    private int rfc = 0;

    public void visitClass(AsmClass asmClass) {
        this.rfc = 0;
        this.asmClass = asmClass;
        this.distinctCallToExternalMethods = new HashSet<AsmMethod>();
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (asmMethod.isBodyLoaded() && !asmMethod.isAccessor()) {
            ++this.rfc;
        }
    }

    public void visitEdge(AsmEdge edge) {
        if (edge.getTargetAsmClass() != this.asmClass && edge.getUsage() == SourceCodeEdgeUsage.CALLS_METHOD && !((AsmMethod)edge.getTo()).isAccessor()) {
            this.distinctCallToExternalMethods.add((AsmMethod)edge.getTo());
        }
    }

    public void leaveClass(AsmClass asmClass) {
        this.rfc += this.distinctCallToExternalMethods.size();
        this.getSourceClass(asmClass).add((MetricDef)Metric.RFC, this.rfc);
        if (this.isMainPublicClassInFile(asmClass)) {
            this.getSourceFile(asmClass).add((MetricDef)Metric.RFC, this.rfc);
        }
    }
}

