/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.signature;

import java.util.ArrayList;
import java.util.List;
import org.sonar.java.signature.JvmJavaType;
import org.sonar.java.signature.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSignatureScanner {
    private final String signature;
    private int index = 0;
    private static final char ARRAY = '[';

    private ParameterSignatureScanner(String parametersSignature) {
        this.signature = parametersSignature;
    }

    public static Parameter scan(String parameterSignature) {
        ParameterSignatureScanner scanner = new ParameterSignatureScanner(parameterSignature);
        if (scanner.hasNext()) {
            return scanner.next();
        }
        return null;
    }

    public static List<Parameter> scanArguments(String argumentsSignature) {
        ArrayList<Parameter> arguments = new ArrayList<Parameter>();
        ParameterSignatureScanner scanner = new ParameterSignatureScanner(argumentsSignature);
        while (scanner.hasNext()) {
            arguments.add(scanner.next());
        }
        return arguments;
    }

    private boolean hasNext() {
        return this.signature.length() > this.index && (this.signature.charAt(this.index) == '[' || this.nextCharIsJvmJavaType());
    }

    private boolean nextCharIsJvmJavaType() {
        try {
            JvmJavaType.valueOf(this.signature.substring(this.index, this.index + 1));
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Parameter next() {
        boolean isArray = false;
        String classCanonicalName = null;
        if (this.signature.charAt(this.index) == '[') {
            isArray = true;
            ++this.index;
        }
        JvmJavaType jvmJavaType = JvmJavaType.valueOf(this.signature.substring(this.index, this.index + 1));
        ++this.index;
        if (jvmJavaType == JvmJavaType.L) {
            int semicolonIndex = this.signature.indexOf(59, this.index);
            classCanonicalName = this.signature.substring(this.index, semicolonIndex);
            this.index = semicolonIndex + 1;
        }
        return new Parameter(jvmJavaType, classCanonicalName, isArray);
    }
}

