/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.text;

import org.apache.commons.lang.StringUtils;
import org.sonar.squid.measures.Measurable;
import org.sonar.squid.measures.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Line
implements Measurable<Metric> {
    private final int lineIndex;
    private int blankLine = 0;
    private int line = 1;
    private int lineOfCode = 0;
    private int commentLine = 0;
    private int headerCommentLine = 0;
    private int commentBlankLine = 0;
    private int commentedOutCodeLine = 0;
    private String comment = null;
    private StringBuilder stringLine;
    private boolean isBlank;
    private boolean isThereJavadoc;
    private boolean isThereLicenseHeaderComment;
    private static final String NOSONAR_TAG = "NOSONAR";

    Line() {
        this.lineIndex = 0;
    }

    Line(String stringLine) {
        this();
        this.setString(new StringBuilder(stringLine));
    }

    Line(int lineIndex, StringBuilder stringLine) {
        this(lineIndex);
        this.setString(stringLine);
    }

    Line(int lineIndex) {
        this.lineIndex = lineIndex;
    }

    final void setString(StringBuilder stringLine) {
        this.stringLine = stringLine;
        this.isBlank = this.isBlankLine();
    }

    private boolean isBlankLine() {
        for (int i = 0; i < this.stringLine.length(); ++i) {
            if (Character.isWhitespace(this.stringLine.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getDouble(Metric metric) {
        return this.getInt(metric);
    }

    @Override
    public int getInt(Metric metric) {
        switch (metric) {
            case BLANK_LINES: {
                return this.blankLine;
            }
            case LINES: {
                return this.line;
            }
            case LINES_OF_CODE: {
                return this.lineOfCode;
            }
            case COMMENT_LINES: {
                return this.commentLine;
            }
            case COMMENTED_OUT_CODE_LINES: {
                return this.commentedOutCodeLine;
            }
            case COMMENT_BLANK_LINES: {
                return this.commentBlankLine;
            }
            case HEADER_COMMENT_LINES: {
                return this.headerCommentLine;
            }
        }
        throw new IllegalStateException("Metric " + metric.name() + " is not available on Line object.");
    }

    @Override
    public void setMeasure(Metric metric, double measure) {
        this.setMeasure(metric, (int)measure);
    }

    @Override
    public void setMeasure(Metric metric, int measure) {
        switch (metric) {
            case BLANK_LINES: {
                this.blankLine = measure;
                break;
            }
            case LINES_OF_CODE: {
                this.lineOfCode = measure;
                break;
            }
            case COMMENT_LINES: {
                this.commentLine = measure;
                break;
            }
            case COMMENTED_OUT_CODE_LINES: {
                this.commentedOutCodeLine = measure;
                break;
            }
            case COMMENT_BLANK_LINES: {
                this.commentBlankLine = measure;
                break;
            }
            case HEADER_COMMENT_LINES: {
                this.headerCommentLine = measure;
                break;
            }
            case LINES: {
                throw new IllegalStateException("Metric LINES always equals 1 on a Line and you are not permitted to change this value.");
            }
            default: {
                throw new IllegalStateException("Metric " + metric.name() + " is not suitable for Line object.");
            }
        }
    }

    void setComment(String comment) {
        this.comment = comment;
    }

    void setComment(String comment, boolean isJavadoc) {
        this.setComment(comment);
        this.isThereJavadoc = isJavadoc;
    }

    void setComment(String comment, boolean isJavadoc, boolean isLicenseHeader) {
        this.setComment(comment, isJavadoc);
        this.isThereLicenseHeaderComment = isLicenseHeader;
    }

    String getString() {
        return this.stringLine.toString();
    }

    boolean isBlank() {
        return !this.isThereComment() && this.isBlank;
    }

    boolean isThereCode() {
        if (!this.isBlank() && !this.isThereComment()) {
            return true;
        }
        return this.isThereComment() && this.isThereCodeBeforeOrAfterComment();
    }

    private boolean isThereCodeBeforeOrAfterComment() {
        if (!this.isThereComment()) {
            throw new IllegalStateException("You can't call this method when there isn't any comment");
        }
        boolean isThereCodeBeforeComment = false;
        boolean isThereCodeAfterComment = false;
        int commentStartIndex = this.stringLine.indexOf(this.comment);
        int commentEndIndex = commentStartIndex + this.comment.length() - 1;
        if (commentStartIndex > 0) {
            boolean bl = isThereCodeBeforeComment = !StringUtils.isBlank((String)this.stringLine.substring(0, commentStartIndex - 1));
        }
        if (commentEndIndex > 0 && commentEndIndex != this.stringLine.length() - 1) {
            isThereCodeAfterComment = !StringUtils.isBlank((String)this.stringLine.substring(commentEndIndex + 1));
        }
        return isThereCodeBeforeComment || isThereCodeAfterComment;
    }

    boolean isThereComment() {
        return this.comment != null;
    }

    String getComment() {
        return this.comment;
    }

    boolean isThereBlankComment() {
        if (this.isThereComment()) {
            for (int i = 0; i < this.comment.length(); ++i) {
                char character = this.comment.charAt(i);
                if (Character.isWhitespace(character) || character == '*' || character == '/') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean isThereJavadoc() {
        return this.isThereJavadoc;
    }

    boolean isThereLicenseHeaderComment() {
        return this.isThereLicenseHeaderComment;
    }

    boolean isThereNoSonarTag() {
        return this.isThereComment() && this.comment.contains(NOSONAR_TAG);
    }

    int getLineIndex() {
        return this.lineIndex;
    }

    void deleteLineContent() {
        this.comment = null;
        this.stringLine = null;
    }
}

