/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.sonar.java.text.Line;
import org.sonar.java.text.LineContextHandler;
import org.sonar.java.text.LiteralValueHandler;
import org.sonar.java.text.MultiLinesCommentHandler;
import org.sonar.java.text.SingleLineCommentHandler;
import org.sonar.squid.api.AnalysisException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LinesFactory {
    private final List<Line> lines = new ArrayList<Line>();
    private char lastReadCharacter;
    private StringBuilder currentStringBuilder = new StringBuilder();
    private Line currentLine;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final int EOF = -1;
    private LineContextHandler currentHandler;
    private LineContextHandler[] handlers;

    LinesFactory(Reader reader, String ... additionalSingleLineCommentFlags) {
        ArrayList<LineContextHandler> tmpHandlers = new ArrayList<LineContextHandler>();
        for (String additionalSingleLineCommentFlag : additionalSingleLineCommentFlags) {
            tmpHandlers.add(new SingleLineCommentHandler(additionalSingleLineCommentFlag));
        }
        tmpHandlers.add(new SingleLineCommentHandler("//", "*//"));
        tmpHandlers.add(new MultiLinesCommentHandler());
        tmpHandlers.add(new LiteralValueHandler('\''));
        tmpHandlers.add(new LiteralValueHandler('\"'));
        this.handlers = tmpHandlers.toArray(new LineContextHandler[tmpHandlers.size()]);
        this.fillLines(new BufferedReader(reader));
    }

    private void fillLines(Reader reader) {
        try {
            this.currentLine = new Line(1);
            while (true) {
                int nextChar;
                if (this.isEndOfFile(nextChar = reader.read())) {
                    this.notifyHandlersAboutEndOfLine();
                    break;
                }
                this.lastReadCharacter = (char)nextChar;
                if (this.isEndOfLine(nextChar)) {
                    this.popOptionalRemainingEndOfLineChar(reader);
                    this.createNewLine();
                    continue;
                }
                this.appendToStringBuilder(nextChar);
                this.notifyHandlersAboutNewChar();
            }
        }
        catch (IOException e) {
            throw new AnalysisException("Unable to read the source code.", e);
        }
        catch (Exception e) {
            throw new AnalysisException("A problem was encountered when analyzing line " + this.lines.size() + " : '" + this.currentStringBuilder.toString() + "'", e);
        }
    }

    private void popOptionalRemainingEndOfLineChar(Reader reader) throws IOException {
        reader.mark(1);
        char nextChar = (char)reader.read();
        reader.reset();
        if (this.isTechnicalCharacter(nextChar) && this.lastReadCharacter != nextChar) {
            reader.read();
        }
    }

    private void notifyHandlersAboutNewChar() {
        if (this.currentHandler == null) {
            for (LineContextHandler handler : this.handlers) {
                if (!handler.matchToBegin(this.currentLine, this.currentStringBuilder)) continue;
                this.currentHandler = handler;
                break;
            }
        } else if (this.currentHandler.matchToEnd(this.currentLine, this.currentStringBuilder)) {
            this.currentHandler = null;
        }
    }

    private void notifyHandlersAboutEndOfLine() {
        if (this.currentHandler != null && this.currentHandler.matchWithEndOfLine(this.currentLine, this.currentStringBuilder)) {
            this.currentHandler = null;
        }
    }

    private void createNewLine() {
        this.notifyHandlersAboutEndOfLine();
        this.currentLine.setString(this.currentStringBuilder);
        this.lines.add(this.currentLine);
        this.currentLine = new Line(this.lines.size() + 1);
        this.currentStringBuilder = new StringBuilder();
    }

    private void appendToStringBuilder(int nextChar) {
        if (!this.isTechnicalCharacter(nextChar)) {
            this.currentStringBuilder.append((char)nextChar);
        }
    }

    private boolean isEndOfFile(int nextChar) {
        return nextChar == -1 && this.currentStringBuilder.length() == 0 && this.lastReadCharacter != '\n';
    }

    private boolean isEndOfLine(int nextChar) {
        return nextChar == -1 || (char)nextChar == '\n' || (char)nextChar == '\r';
    }

    private boolean isTechnicalCharacter(int nextChar) {
        return nextChar == 10 || nextChar == 13 || nextChar == -1;
    }

    List<Line> getLines() {
        return this.lines;
    }
}

