/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.text;

import org.sonar.java.text.Line;
import org.sonar.java.text.LineContextHandler;

public class LiteralValueHandler
extends LineContextHandler {
    private final char delimiter;

    public LiteralValueHandler(char delimiter) {
        this.delimiter = delimiter;
    }

    boolean matchToEnd(Line line, StringBuilder pendingLine) {
        return LiteralValueHandler.matchEndOfString(pendingLine, this.delimiter) && this.evenNumberOfBackSlashBeforeDelimiter(pendingLine);
    }

    private boolean evenNumberOfBackSlashBeforeDelimiter(StringBuilder pendingLine) {
        int numberOfBackSlashChar = 0;
        for (int index = pendingLine.length() - 2; index >= 0 && pendingLine.charAt(index) == '\\'; --index) {
            ++numberOfBackSlashChar;
        }
        return numberOfBackSlashChar % 2 == 0;
    }

    boolean matchToBegin(Line line, StringBuilder pendingLine) {
        return LiteralValueHandler.matchEndOfString(pendingLine, this.delimiter);
    }

    boolean matchWithEndOfLine(Line line, StringBuilder pendingLine) {
        return true;
    }
}

