/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class StringArrayReader
extends Reader {
    private final StringReader stringReader;

    public StringArrayReader(String[] lines) {
        this(lines, EndOfLineDelimiter.LF);
    }

    public StringArrayReader(String[] lines, EndOfLineDelimiter endOfLineDelimiter) {
        if (lines == null) {
            throw new IllegalStateException("lines object can't be null.");
        }
        String content = this.convertArrayToStringAndAppendEndOfLine(lines, endOfLineDelimiter);
        this.stringReader = new StringReader(content);
    }

    private String convertArrayToStringAndAppendEndOfLine(String[] lines, EndOfLineDelimiter endOfLineDelimiter) {
        StringBuilder content = new StringBuilder();
        block5: for (int i = 0; i < lines.length; ++i) {
            content.append(lines[i]);
            if (i == lines.length - 1) continue;
            switch (endOfLineDelimiter) {
                case LF: {
                    content.append('\n');
                    continue block5;
                }
                case CR: {
                    content.append('\r');
                    continue block5;
                }
                case CR_PLUS_LF: {
                    content.append("\r\n");
                }
            }
        }
        return content.toString();
    }

    public void close() throws IOException {
        this.stringReader.close();
    }

    public boolean ready() throws IOException {
        return this.stringReader.ready();
    }

    public boolean markSupported() {
        return this.stringReader.markSupported();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.stringReader.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.stringReader.reset();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.stringReader.read(cbuf, off, len);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EndOfLineDelimiter {
        LF,
        CR_PLUS_LF,
        CR;

    }
}

