/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.api;

import java.util.HashSet;
import java.util.Set;
import org.sonar.graph.Edge;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceCodeEdgeUsage;

public class SourceCodeEdge
implements Edge<SourceCode> {
    private final SourceCode from;
    private final SourceCode to;
    private final SourceCodeEdgeUsage usage;
    private Set<SourceCodeEdge> rootEdges;
    private Set<SourceCode> rootFromNodes;
    private Set<SourceCode> rootToNodes;
    private final int hashcode;
    private SourceCodeEdge parent;

    public SourceCodeEdge(SourceCode from, SourceCode to, SourceCodeEdgeUsage link) {
        this(from, to, link, null);
    }

    public SourceCodeEdge(SourceCode from, SourceCode to, SourceCodeEdgeUsage usage, SourceCodeEdge rootEdge) {
        this.hashcode = from.hashCode() * 31 + to.hashCode() + usage.hashCode();
        this.from = from;
        this.to = to;
        this.usage = usage;
        this.addRootEdge(rootEdge);
    }

    public SourceCode getFrom() {
        return this.from;
    }

    public SourceCode getTo() {
        return this.to;
    }

    public SourceCodeEdgeUsage getUsage() {
        return this.usage;
    }

    private boolean noRoots() {
        return this.rootEdges == null;
    }

    public boolean hasAnEdgeFromRootNode(SourceCode rootFromNode) {
        if (this.noRoots()) {
            return false;
        }
        return this.rootFromNodes.contains(rootFromNode);
    }

    public boolean hasAnEdgeToRootNode(SourceCode rootToNode) {
        if (this.noRoots()) {
            return false;
        }
        return this.rootToNodes.contains(rootToNode);
    }

    public Set<SourceCodeEdge> getRootEdges() {
        return this.rootEdges;
    }

    public int getNumberOfRootFromNodes() {
        if (this.noRoots()) {
            return 0;
        }
        return this.rootFromNodes.size();
    }

    public final void addRootEdge(SourceCodeEdge rootRelationShip) {
        if (this.noRoots()) {
            this.rootEdges = new HashSet<SourceCodeEdge>();
            this.rootFromNodes = new HashSet<SourceCode>();
            this.rootToNodes = new HashSet<SourceCode>();
        }
        if (rootRelationShip != null) {
            this.rootEdges.add(rootRelationShip);
            this.rootFromNodes.add(rootRelationShip.getFrom());
            this.rootToNodes.add(rootRelationShip.getTo());
            rootRelationShip.setParent(this);
        }
    }

    public int getWeight() {
        if (this.noRoots()) {
            return 0;
        }
        return this.rootEdges.size();
    }

    public SourceCodeEdge getParent() {
        return this.parent;
    }

    public SourceCodeEdge setParent(SourceCodeEdge parent) {
        this.parent = parent;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceCodeEdge) || this.hashCode() != obj.hashCode()) {
            return false;
        }
        SourceCodeEdge edge = (SourceCodeEdge)obj;
        return this.from.equals(edge.from) && this.to.equals(edge.to);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return "from : " + this.from + ", to : " + this.to;
    }
}

