/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squid.text;

import org.sonar.squid.text.Line;
import org.sonar.squid.text.LineContextHandler;

public class MultiLinesCommentHandler
extends LineContextHandler {
    private StringBuilder currentLineComment;
    private boolean isFirstLineOfComment = false;
    private boolean isJavadoc = false;
    private boolean isLicenseHeader = false;
    private boolean commentStarted = false;
    private static final String START_COMMENT_TAG = "/*";
    private static final String START_JAVADOC_TAG = "/**";
    private static final String START_GWT_NATIVE_CODE_TAG = "/*-{";
    private static final String END_COMMENT_TAG = "*/";

    @Override
    boolean matchToEnd(Line line, StringBuilder pendingLine) {
        if (!this.commentStarted) {
            throw new IllegalStateException("Method doContextBegin(StringBuilder pendingLine) has not been called first (line = '" + pendingLine + "').");
        }
        this.currentLineComment.append(MultiLinesCommentHandler.getLastCharacter(pendingLine));
        if (this.isJavaDoc()) {
            this.isJavadoc = true;
        }
        if (this.isGwtNativeCode()) {
            this.initProperties();
            return true;
        }
        boolean match = MultiLinesCommentHandler.matchEndOfString(pendingLine, END_COMMENT_TAG);
        if (match && (!this.isFirstLineOfComment || pendingLine.indexOf(START_COMMENT_TAG) + 1 != pendingLine.indexOf(END_COMMENT_TAG))) {
            this.endOfCommentLine(line);
            this.initProperties();
            return true;
        }
        return false;
    }

    private boolean isGwtNativeCode() {
        return this.isFirstLineOfComment && this.currentLineComment.length() == START_GWT_NATIVE_CODE_TAG.length() && this.currentLineComment.toString().equals(START_GWT_NATIVE_CODE_TAG);
    }

    private boolean isJavaDoc() {
        return this.isFirstLineOfComment && this.currentLineComment.length() == START_JAVADOC_TAG.length() && this.currentLineComment.toString().equals(START_JAVADOC_TAG);
    }

    @Override
    boolean matchToBegin(Line line, StringBuilder pendingLine) {
        boolean match = MultiLinesCommentHandler.matchEndOfString(pendingLine, START_COMMENT_TAG);
        if (match) {
            this.isFirstLineOfComment = true;
            this.commentStarted = true;
            this.currentLineComment = new StringBuilder(START_COMMENT_TAG);
            this.isLicenseHeader = line.getLineIndex() == 1;
        }
        return match;
    }

    @Override
    boolean matchWithEndOfLine(Line line, StringBuilder pendingLine) {
        this.endOfCommentLine(line);
        return false;
    }

    private void endOfCommentLine(Line line) {
        line.setComment(this.currentLineComment.toString(), this.isJavadoc, this.isLicenseHeader);
        this.currentLineComment = new StringBuilder();
        this.isFirstLineOfComment = false;
    }

    private void initProperties() {
        this.commentStarted = false;
        this.isJavadoc = false;
        this.isLicenseHeader = false;
        this.currentLineComment = new StringBuilder();
        this.isFirstLineOfComment = false;
    }
}

