/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.i18n;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.sonar.test.TestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleSynchronizedMatcher
extends BaseMatcher<String> {
    public static final String L10N_PATH = "/org/sonar/l10n/";
    private static final String GITHUB_RAW_FILE_PATH = "https://raw.github.com/SonarSource/sonar/master/plugins/sonar-l10n-en-plugin/src/main/resources/org/sonar/l10n/";
    private static final Collection<String> CORE_BUNDLES = Lists.newArrayList((Object[])new String[]{"checkstyle.properties", "core.properties", "findbugs.properties", "gwt.properties", "pmd.properties", "squidjava.properties"});
    private String sonarVersion;
    private String remote_file_path;
    private String bundleName;
    private SortedMap<String, String> missingKeys;
    private SortedMap<String, String> additionalKeys;

    public BundleSynchronizedMatcher(String sonarVersion) {
        this(sonarVersion, GITHUB_RAW_FILE_PATH);
    }

    public BundleSynchronizedMatcher(String sonarVersion, String remote_file_path) {
        this.sonarVersion = sonarVersion;
        this.remote_file_path = remote_file_path;
    }

    public boolean matches(Object arg0) {
        if (!(arg0 instanceof String)) {
            return false;
        }
        this.bundleName = (String)arg0;
        File bundle = this.getBundleFileFromClasspath(this.bundleName);
        String defaultBundleName = this.extractDefaultBundleName(this.bundleName);
        File defaultBundle = this.isCoreBundle(defaultBundleName) ? this.getBundleFileFromGithub(defaultBundleName) : this.getBundleFileFromClasspath(defaultBundleName);
        try {
            this.missingKeys = this.retrieveMissingTranslations(bundle, defaultBundle);
            this.additionalKeys = this.retrieveMissingTranslations(defaultBundle, bundle);
            return this.missingKeys.isEmpty();
        }
        catch (IOException e) {
            Assert.fail((String)("An error occured while reading the bundles: " + e.getMessage()));
            return false;
        }
    }

    public void describeTo(Description description) {
        File dumpFile = new File("target/l10n/" + this.bundleName + ".report.txt");
        StringBuilder details = this.prepareDetailsMessage(dumpFile);
        description.appendText(details.toString());
        this.printReport(dumpFile, details.toString());
    }

    private StringBuilder prepareDetailsMessage(File dumpFile) {
        StringBuilder details = new StringBuilder("\n=======================\n'");
        details.append(this.bundleName);
        details.append("' is not up-to-date.");
        this.print("\n\n Missing translations are:", this.missingKeys, details);
        this.print("\n\nThe following translations do not exist in the reference bundle:", this.additionalKeys, details);
        details.append("\n\nSee report file located at: " + dumpFile.getAbsolutePath());
        details.append("\n=======================");
        return details;
    }

    private void print(String title, SortedMap<String, String> translations, StringBuilder to) {
        if (!translations.isEmpty()) {
            to.append(title);
            for (Map.Entry<String, String> entry : translations.entrySet()) {
                to.append("\n").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printReport(File dumpFile, String details) {
        if (dumpFile.exists()) {
            dumpFile.delete();
        }
        dumpFile.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(dumpFile);
            writer.write(details);
        }
        catch (IOException e) {
            try {
                System.out.println("Unable to write the report to 'target/l10n/" + this.bundleName + ".report.txt'.");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    protected SortedMap<String, String> retrieveMissingTranslations(File bundle, File referenceBundle) throws IOException {
        TreeMap missingKeys = Maps.newTreeMap();
        Properties bundleProps = this.loadProperties(bundle);
        Properties referenceProperties = this.loadProperties(referenceBundle);
        for (Map.Entry<Object, Object> entry : referenceProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (bundleProps.containsKey(key)) continue;
            missingKeys.put(key, (String)entry.getValue());
        }
        return missingKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File f) throws IOException {
        Properties props = new Properties();
        FileInputStream input = new FileInputStream(f);
        try {
            props.load(input);
            Properties properties = props;
            return properties;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    protected File getBundleFileFromGithub(String defaultBundleName) {
        File localBundle = new File("target/l10n/download/" + defaultBundleName);
        try {
            String remoteFile = this.computeGitHubURL(defaultBundleName, this.sonarVersion);
            this.saveUrlToLocalFile(remoteFile, localBundle);
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Could not download the original core bundle at: " + this.remote_file_path + defaultBundleName));
        }
        catch (IOException e) {
            Assert.fail((String)("Could not download the original core bundle at: " + this.remote_file_path + defaultBundleName));
        }
        Assert.assertThat((String)("File 'target/tmp/" + defaultBundleName + "' has been downloaded but does not exist."), (Object)localBundle, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)("File 'target/tmp/" + defaultBundleName + "' has been downloaded but does not exist."), (Object)localBundle.exists(), (Matcher)Matchers.is((Object)true));
        return localBundle;
    }

    protected String computeGitHubURL(String defaultBundleName, String sonarVersion) {
        String computedURL = this.remote_file_path + defaultBundleName;
        if (sonarVersion != null && !sonarVersion.contains("-SNAPSHOT")) {
            computedURL = computedURL.replace("/master/", "/" + sonarVersion + "/");
        }
        return computedURL;
    }

    protected File getBundleFileFromClasspath(String bundleName) {
        File bundle = TestUtils.getResource(L10N_PATH + bundleName);
        Assert.assertThat((String)("File '" + bundleName + "' does not exist in '/org/sonar/l10n/'."), (Object)bundle, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)("File '" + bundleName + "' does not exist in '/org/sonar/l10n/'."), (Object)bundle.exists(), (Matcher)Matchers.is((Object)true));
        return bundle;
    }

    protected String extractDefaultBundleName(String bundleName) {
        int firstUnderScoreIndex = bundleName.indexOf(95);
        Assert.assertThat((String)("The bundle '" + bundleName + "' is a default bundle (without locale), so it can't be compared."), (Object)(firstUnderScoreIndex > 0 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        return bundleName.substring(0, firstUnderScoreIndex) + ".properties";
    }

    protected boolean isCoreBundle(String defaultBundleName) {
        return CORE_BUNDLES.contains(defaultBundleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUrlToLocalFile(String url, File localFile) throws MalformedURLException, IOException {
        if (localFile.exists()) {
            localFile.delete();
        }
        localFile.getParentFile().mkdirs();
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            in = new BufferedInputStream(new URL(url).openStream());
            fout = new FileOutputStream(localFile);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }
}

