/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test.persistence;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.dbunit.Assertion;
import org.dbunit.DatabaseUnitException;
import org.dbunit.IDatabaseTester;
import org.dbunit.JdbcDatabaseTester;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class DatabaseTestCase {
    private static IDatabaseTester databaseTester = null;
    private static final String JDBC_URL = "jdbc:derby:memory:sonar";
    private Connection connection = null;

    @BeforeClass
    public static void startDatabase() throws Exception {
        System.setProperty("derby.stream.error.file", "target/derby.log");
        EmbeddedDriver driver = new EmbeddedDriver();
        DriverManager.registerDriver((Driver)driver);
        databaseTester = new JdbcDatabaseTester(driver.getClass().getName(), "jdbc:derby:memory:sonar;create=true");
        DatabaseTestCase.createDatabase();
    }

    private static void createDatabase() throws Exception {
        Connection c = databaseTester.getConnection().getConnection();
        Statement st = c.createStatement();
        for (String ddl : DatabaseTestCase.loadDdlStatements()) {
            st.executeUpdate(ddl);
            c.commit();
        }
        st.close();
        c.close();
    }

    private static String[] loadDdlStatements() throws Exception {
        InputStream in = DatabaseTestCase.class.getResourceAsStream("/org/sonar/test/persistence/sonar-test.ddl");
        List lines = IOUtils.readLines((InputStream)in);
        StringBuilder ddl = new StringBuilder();
        for (String line : lines) {
            if (!StringUtils.isNotBlank((String)line) || StringUtils.startsWith((String)StringUtils.trimToEmpty((String)line), (String)"#")) continue;
            ddl.append(line).append(" ");
        }
        in.close();
        return StringUtils.split((String)StringUtils.trim((String)ddl.toString()), (String)";");
    }

    @AfterClass
    public static void stopDatabase() throws Exception {
        try {
            DriverManager.getConnection("jdbc:derby:memory:sonar;drop=true");
            databaseTester.onTearDown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IDatabaseTester getDatabaseTester() {
        return databaseTester;
    }

    protected final Connection getConnection() {
        try {
            if (this.connection == null) {
                this.connection = DatabaseTestCase.getDatabaseTester().getConnection().getConnection();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.connection;
    }

    @After
    public final void truncateTables() throws SQLException {
        ResultSet rs = this.getConnection().getMetaData().getTables(null, "APP", null, null);
        Statement st = this.getConnection().createStatement();
        while (rs.next()) {
            String tableName = rs.getString(3);
            st.executeUpdate("TRUNCATE TABLE " + tableName);
        }
        st.close();
        rs.close();
        this.getConnection().commit();
    }

    @After
    public final void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setupData(String ... testNames) {
        InputStream[] streams = new InputStream[testNames.length];
        try {
            for (int i = 0; i < testNames.length; ++i) {
                String className = this.getClass().getName();
                className = String.format("/%s/%s.xml", className.replace(".", "/"), testNames[i]);
                streams[i] = this.getClass().getResourceAsStream(className);
                if (streams[i] != null) continue;
                throw new RuntimeException("Test not found :" + className);
            }
            this.setupData(streams);
        }
        finally {
            for (InputStream stream : streams) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private void setupData(InputStream ... dataSetStream) {
        try {
            IDataSet[] dataSets = new IDataSet[dataSetStream.length];
            for (int i = 0; i < dataSetStream.length; ++i) {
                ReplacementDataSet dataSet = new ReplacementDataSet((IDataSet)new FlatXmlDataSet(dataSetStream[i]));
                dataSet.addReplacementObject((Object)"[null]", null);
                dataSet.addReplacementObject((Object)"true", (Object)1);
                dataSet.addReplacementObject((Object)"false", (Object)0);
                dataSets[i] = dataSet;
            }
            CompositeDataSet compositeDataSet = new CompositeDataSet(dataSets);
            DatabaseOperation.CLEAN_INSERT.execute(DatabaseTestCase.getDatabaseTester().getConnection(), (IDataSet)compositeDataSet);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup DBUnit data", e);
        }
    }

    protected final void assertTables(String testName, String ... tables) {
        try {
            IDataSet dataSet = this.getCurrentDataSet();
            IDataSet expectedDataSet = this.getExpectedData(testName);
            for (String table : tables) {
                Assertion.assertEquals((ITable)expectedDataSet.getTable(table), (ITable)dataSet.getTable(table));
            }
        }
        catch (DataSetException e) {
            throw DatabaseTestCase.translateException("Error while checking results", (Exception)((Object)e));
        }
        catch (DatabaseUnitException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected final void assertTables(String testName, String[] tables, String[] ignoreCols) {
        try {
            IDataSet dataSet = this.getCurrentDataSet();
            IDataSet expectedDataSet = this.getExpectedData(testName);
            for (String table : tables) {
                Assertion.assertEqualsIgnoreCols((ITable)expectedDataSet.getTable(table), (ITable)dataSet.getTable(table), (String[])ignoreCols);
            }
        }
        catch (DataSetException e) {
            throw DatabaseTestCase.translateException("Error while checking results", (Exception)((Object)e));
        }
        catch (DatabaseUnitException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected final void assertEmptyTables(String ... emptyTables) {
        for (String table : emptyTables) {
            try {
                Assert.assertEquals((long)0L, (long)this.getCurrentDataSet().getTable(table).getRowCount());
            }
            catch (DataSetException e) {
                throw DatabaseTestCase.translateException("Error while checking results", (Exception)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDataSet getExpectedData(String testName) {
        String className = this.getClass().getName();
        className = String.format("/%s/%s-result.xml", className.replace(".", "/"), testName);
        InputStream in = this.getClass().getResourceAsStream(className);
        try {
            IDataSet iDataSet = this.getData(in);
            return iDataSet;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private IDataSet getData(InputStream stream) {
        try {
            ReplacementDataSet dataSet = new ReplacementDataSet((IDataSet)new FlatXmlDataSet(stream));
            dataSet.addReplacementObject((Object)"[null]", null);
            return dataSet;
        }
        catch (Exception e) {
            throw DatabaseTestCase.translateException("Could not read the dataset stream", e);
        }
    }

    private IDataSet getCurrentDataSet() {
        try {
            return databaseTester.getConnection().createDataSet();
        }
        catch (Exception e) {
            throw DatabaseTestCase.translateException("Could not create the current dataset", e);
        }
    }

    private static RuntimeException translateException(String msg, Exception cause) {
        RuntimeException runtimeException = new RuntimeException(String.format("%s: [%s] %s", msg, cause.getClass().getName(), cause.getMessage()));
        runtimeException.setStackTrace(cause.getStackTrace());
        return runtimeException;
    }
}

