/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.sonar.api.utils.SonarException;

public final class TestUtils {
    private TestUtils() {
    }

    public static File getResource(String path) {
        URL url;
        String resourcePath = path;
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        if ((url = TestUtils.class.getResource(resourcePath)) != null) {
            return FileUtils.toFile((URL)url);
        }
        return null;
    }

    public static String getResourceContent(String path) {
        URL url = TestUtils.class.getResource(path);
        if (url == null) {
            return null;
        }
        try {
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new SonarException("Can not load the resource: " + path, (Throwable)e);
        }
    }

    public static File getResource(Class baseClass, String path) {
        String resourcePath = StringUtils.replaceChars((String)baseClass.getCanonicalName(), (char)'.', (char)'/');
        if (!path.startsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        resourcePath = resourcePath + path;
        return TestUtils.getResource(resourcePath);
    }

    public static File getTestTempDir(Class baseClass, String testName) {
        return TestUtils.getTestTempDir(baseClass, testName, true);
    }

    public static File getTestTempDir(Class baseClass, String testName, boolean clean) {
        File dir = new File("target/test-tmp/" + baseClass.getCanonicalName() + "/" + testName);
        if (clean && dir.exists()) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                throw new SonarException("Can not delete the directory " + dir, (Throwable)e);
            }
        }
        try {
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            throw new SonarException("Can not create the directory " + dir, (Throwable)e);
        }
        return dir;
    }

    public static void assertExists(File file) {
        Assert.assertNotNull((Object)file);
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)true));
    }

    public static void assertSimilarXml(String expectedXml, String xml) throws Exception {
        Diff diff = TestUtils.isSimilarXml(expectedXml, xml);
        String message = "Diff: " + diff.toString() + '\n' + "XML: " + xml;
        Assert.assertTrue((String)message, (boolean)diff.similar());
    }

    static Diff isSimilarXml(String expectedXml, String xml) throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        return XMLUnit.compareXML((String)xml, (String)expectedXml);
    }
}

