/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.skyscreamer.jsonassert.JSONAssert;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.api.utils.text.XmlWriter;

public class WsTester {
    private final WebService.Context context = new WebService.Context();

    public WsTester(WebService ... webServices) {
        for (WebService webService : webServices) {
            webService.define(this.context);
        }
    }

    public WebService.Context context() {
        return this.context;
    }

    @CheckForNull
    public WebService.Controller controller(String path) {
        return this.context.controller(path);
    }

    public TestRequest newRequest(String actionKey) {
        if (this.context.controllers().size() != 1) {
            throw new IllegalStateException("The method newRequest(String) requires to define one, and only one, controller");
        }
        WebService.Controller controller = (WebService.Controller)this.context.controllers().get(0);
        WebService.Action action = controller.action(actionKey);
        if (action == null) {
            throw new IllegalArgumentException("Action not found: " + actionKey);
        }
        return new TestRequest(controller, action);
    }

    public TestRequest newRequest(String controllerPath, String actionKey) {
        WebService.Controller controller = this.context.controller(controllerPath);
        WebService.Action action = controller.action(actionKey);
        return new TestRequest(controller, action);
    }

    public static class Result {
        private final TestResponse response;

        private Result(TestResponse response) {
            this.response = response;
        }

        public Result assertNoContent() {
            return this;
        }

        public String outputAsString() {
            return new String(this.response.output.toByteArray(), Charsets.UTF_8);
        }

        public Result assertJson(String expectedJson) throws Exception {
            String json = this.outputAsString();
            JSONAssert.assertEquals((String)expectedJson, (String)json, (boolean)true);
            return this;
        }

        public Result assertJson(Class clazz, String expectedJsonFilename) throws Exception {
            String path = clazz.getSimpleName() + "/" + expectedJsonFilename;
            URL url = clazz.getResource(path);
            if (url == null) {
                throw new IllegalStateException("Cannot find " + path);
            }
            String json = this.outputAsString();
            JSONAssert.assertEquals((String)IOUtils.toString((URL)url), (String)json, (boolean)true);
            return this;
        }
    }

    public static class TestResponse
    implements Response {
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();

        public JsonWriter newJsonWriter() {
            return JsonWriter.of((Writer)new OutputStreamWriter((OutputStream)this.output, Charsets.UTF_8));
        }

        public XmlWriter newXmlWriter() {
            return XmlWriter.of((Writer)new OutputStreamWriter((OutputStream)this.output, Charsets.UTF_8));
        }

        public Response.Stream stream() {
            return new TestStream();
        }

        public Response noContent() {
            IOUtils.closeQuietly((OutputStream)this.output);
            return this;
        }

        public class TestStream
        implements Response.Stream {
            private String mediaType;
            private int status;

            @CheckForNull
            public String mediaType() {
                return this.mediaType;
            }

            public int status() {
                return this.status;
            }

            public Response.Stream setMediaType(String s) {
                this.mediaType = s;
                return this;
            }

            public Response.Stream setStatus(int i) {
                this.status = i;
                return this;
            }

            public OutputStream output() {
                return TestResponse.this.output;
            }
        }
    }

    public static class TestRequest
    extends Request {
        private final WebService.Controller controller;
        private final WebService.Action action;
        private String method = "GET";
        private Map<String, String> params = new HashMap<String, String>();

        private TestRequest(WebService.Controller controller, WebService.Action action) {
            this.controller = controller;
            this.action = action;
        }

        public WebService.Action action() {
            return this.action;
        }

        public String method() {
            return this.method;
        }

        public TestRequest setMethod(String s) {
            this.method = s;
            return this;
        }

        public TestRequest setParams(Map<String, String> m) {
            this.params = m;
            return this;
        }

        public TestRequest setParam(String key, @CheckForNull String value) {
            if (value != null) {
                this.params.put(key, value);
            }
            return this;
        }

        @CheckForNull
        public String param(String key) {
            return this.params.get(key);
        }

        public Result execute() {
            TestResponse response = new TestResponse();
            this.action.handler().handle((Request)this, (Response)response);
            return new Result(response);
        }
    }
}

