/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.test;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public final class TestUtils {
    private TestUtils() {
    }

    public static File getResource(String path) {
        URL url;
        String resourcePath = path;
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        if ((url = TestUtils.class.getResource(resourcePath)) != null) {
            return FileUtils.toFile((URL)url);
        }
        return null;
    }

    public static File getResource(Class baseClass, String path) {
        String resourcePath = StringUtils.replaceChars((String)baseClass.getCanonicalName(), (char)'.', (char)'/');
        if (!path.startsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        resourcePath = resourcePath + path;
        return TestUtils.getResource(resourcePath);
    }

    public static boolean hasOnlyPrivateConstructors(Class clazz) {
        boolean ok = true;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            ok &= Modifier.isPrivate(constructor.getModifiers());
            if (constructor.getParameterTypes().length != 0) continue;
            constructor.setAccessible(true);
            try {
                constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Fail to instantiate %s", clazz), e);
            }
        }
        return ok;
    }
}

