/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;
import org.sonar.updatecenter.common.exception.DependencyCycleException;
import org.sonar.updatecenter.common.exception.IncompatiblePluginVersionException;
import org.sonar.updatecenter.common.exception.PluginNotFoundException;

public class PluginReferential {
    private Set<Plugin> plugins = Sets.newTreeSet();

    private PluginReferential() {
    }

    public static PluginReferential create(List<Plugin> pluginList) {
        PluginReferential pluginReferential = new PluginReferential();
        for (Plugin plugin : pluginList) {
            pluginReferential.add(plugin);
        }
        return pluginReferential;
    }

    public static PluginReferential createEmpty() {
        return PluginReferential.create(Lists.newArrayList());
    }

    public List<Plugin> getLastMasterReleasePlugins() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.plugins, (Predicate)new Predicate<Plugin>(){

            public boolean apply(Plugin input) {
                return input.getLastRelease().isMaster();
            }
        }));
    }

    public List<Plugin> getPlugins() {
        return Lists.newArrayList(this.plugins);
    }

    public Plugin findPlugin(final String key) {
        try {
            return (Plugin)Iterables.find(this.plugins, (Predicate)new Predicate<Plugin>(){

                public boolean apply(Plugin input) {
                    return input.getKey().equals(key);
                }
            });
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("Unable to find plugin with key " + key);
        }
    }

    public boolean doesContainPlugin(final String key) {
        return Iterables.any(this.plugins, (Predicate)new Predicate<Plugin>(){

            public boolean apply(Plugin input) {
                return input.getKey().equals(key);
            }
        });
    }

    public boolean doesContainRelease(String key, Version version) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getKey().equals(key) || !plugin.doesContainVersion(version)) continue;
            return true;
        }
        return false;
    }

    public List<String> findLastReleasesWithDependencies(String pluginKey) {
        ArrayList removablePlugins = Lists.newArrayList();
        Plugin plugin = this.findPlugin(pluginKey);
        if (plugin != null) {
            Release pluginRelease = plugin.getLastRelease();
            removablePlugins.add(plugin.getKey());
            for (Release child : pluginRelease.getChildren()) {
                removablePlugins.add(child.getKey());
            }
            for (Release incomingDependencies : pluginRelease.getIncomingDependencies()) {
                removablePlugins.addAll(this.findLastReleasesWithDependencies(incomingDependencies.getArtifact().getKey()));
            }
        }
        return removablePlugins;
    }

    public PluginReferential setParent(Release release, String parentKey) {
        try {
            Plugin pluginParent = this.findPlugin(parentKey);
            Release parent = this.getParentRelease(release, pluginParent);
            release.setParent(parent);
            parent.addChild(release);
            return this;
        }
        catch (NoSuchElementException e) {
            throw new PluginNotFoundException(String.format("The plugin '%s' required by the plugin '%s' is missing.", parentKey, release.getKey()), e);
        }
    }

    private Release getParentRelease(Release release, Plugin pluginParent) {
        try {
            return pluginParent.getRelease(release.getVersion());
        }
        catch (NoSuchElementException e) {
            throw new IncompatiblePluginVersionException(String.format("The plugins '%s' and '%s' must have exactly the same version as they belong to the same group.", release.getKey(), pluginParent.key), e);
        }
    }

    public void addOutgoingDependency(Release release, String requiredPluginReleaseKey, String requiredMinimumReleaseVersion) {
        try {
            Plugin requiredPlugin = this.findPlugin(requiredPluginReleaseKey);
            Release minimalRequiredRelease = requiredPlugin.getMinimalRelease(Version.create(requiredMinimumReleaseVersion));
            if (minimalRequiredRelease != null) {
                release.addOutgoingDependency(minimalRequiredRelease);
                minimalRequiredRelease.addIncomingDependency(release);
                this.checkDependencyCycle(release);
            } else {
                Release latest = requiredPlugin.getLastRelease();
                if (latest != null) {
                    throw new IncompatiblePluginVersionException(String.format("The plugin '%s' is in version %s whereas the plugin '%s' requires a least a version %s.", requiredPlugin.getKey(), latest.getVersion().getName(), release.getArtifact().getKey(), requiredMinimumReleaseVersion));
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new PluginNotFoundException(String.format("The plugin '%s' required by '%s' is missing.", requiredPluginReleaseKey, release.getArtifact().getKey()), e);
        }
    }

    private void checkDependencyCycle(Release release) {
        ArrayList releases = Lists.newArrayList();
        try {
            this.checkDependencyCycle(release, releases);
        }
        catch (DependencyCycleException e) {
            ArrayList releaseKeys = Lists.newArrayList((Iterable)Iterables.transform((Iterable)releases, (Function)new Function<Release, String>(){

                public String apply(Release input) {
                    return input.getArtifact().getKey();
                }
            }));
            throw new DependencyCycleException("There is a dependency cycle between plugins '" + Joiner.on((String)"', '").join((Iterable)releaseKeys) + "' that must be cut.", e);
        }
    }

    private void checkDependencyCycle(Release release, List<Release> releases) {
        for (Release outgoingDependency : release.getOutgoingDependencies()) {
            if (releases.contains(outgoingDependency)) {
                throw new DependencyCycleException();
            }
            releases.add(outgoingDependency);
            this.checkDependencyCycle(outgoingDependency, releases);
        }
    }

    List<Release> getLastMasterReleases() {
        ArrayList releases = Lists.newArrayList();
        for (Plugin plugin : this.getLastMasterReleasePlugins()) {
            releases.add(plugin.getLastRelease());
        }
        return releases;
    }

    private PluginReferential add(Plugin plugin) {
        this.plugins.add(plugin);
        return this;
    }
}

