/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.sonar.updatecenter.api.History;
import org.sonar.updatecenter.api.Plugin;
import org.sonar.updatecenter.api.Sonar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateCenter {
    @Option(name="-d")
    public File outputDirectory = new File("/tmp/site");
    private static final String ARTIFACT_JAR_TYPE = "jar";
    private static final String ARTIFACT_POM_TYPE = "pom";
    private List<ArtifactRepository> remoteRepositories;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactMetadataSource metadataSource;
    private MavenProjectBuilder mavenProjectBuilder;

    private void run() throws Exception {
        ClassWorld classWorld = new ClassWorld("plexus.core", UpdateCenter.class.getClassLoader());
        ContainerConfiguration configuration = new DefaultContainerConfiguration().setClassWorld(classWorld);
        DefaultPlexusContainer plexus = new DefaultPlexusContainer(configuration);
        this.artifactFactory = (ArtifactFactory)plexus.lookup(ArtifactFactory.class);
        this.artifactResolver = (ArtifactResolver)plexus.lookup(ArtifactResolver.class);
        this.metadataSource = (ArtifactMetadataSource)plexus.lookup(ArtifactMetadataSource.class);
        this.mavenProjectBuilder = (MavenProjectBuilder)plexus.lookup(MavenProjectBuilder.class);
        ArtifactRepositoryFactory artifactRepositoryFactory = (ArtifactRepositoryFactory)plexus.lookup(ArtifactRepositoryFactory.class);
        ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy(true, "daily", "warn");
        this.remoteRepositories = Collections.singletonList(artifactRepositoryFactory.createArtifactRepository("codehaus", "http://repository.codehaus.org/", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), policy, policy));
        File localRepo = new File(new File(System.getProperty("user.home")), ".m2/repository");
        this.localRepository = artifactRepositoryFactory.createArtifactRepository("local", localRepo.toURI().toURL().toExternalForm(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), policy, policy);
        JSONObject obj = new JSONObject();
        obj.put((Object)"version", (Object)"1");
        obj.put((Object)"plugins", (Object)this.resolvePlugins());
        obj.put((Object)"sonar", (Object)this.resolveSonar());
        if (this.outputDirectory != null) {
            FileUtils.writeStringToFile((File)new File(this.outputDirectory, "update-center.json"), (String)obj.toJSONString());
        }
    }

    private JSONArray resolvePlugins() throws Exception {
        List plugins = FileUtils.readLines((File)FileUtils.toFile((URL)this.getClass().getResource("/plugins.txt")));
        String pluginInfoWidgetTemplate = FileUtils.readFileToString((File)FileUtils.toFile((URL)this.getClass().getResource("/plugin-info-widget-template.html")));
        if (this.outputDirectory != null) {
            FileUtils.copyURLToFile((URL)this.getClass().getResource("/style.css"), (File)new File(this.outputDirectory, "plugins/style.css"));
        }
        JSONArray json = new JSONArray();
        for (String plugin : plugins) {
            if (plugin.startsWith("#")) continue;
            History<Plugin> history = this.resolvePluginHistory(plugin);
            if (history.latest() == null) {
                System.out.println("WTF? " + plugin);
                continue;
            }
            json.add((Object)history.latest().toJsonObject());
            Plugin latest = history.latest();
            if (this.outputDirectory != null) {
                String pluginInfoWidget = StringUtils.replaceEach((String)pluginInfoWidgetTemplate, (String[])new String[]{"%name%", "%version%", "%date%", "%downloadUrl%", "%sonarVersion%", "%issueTracker%", "%sources%", "%license%", "%developers%"}, (String[])new String[]{latest.getName(), latest.getVersion(), latest.getReleaseDate(), latest.getDownloadUrl(), latest.getRequiredSonarVersion(), this.formatLink(latest.getIssueTracker()), this.formatLink(latest.getSources()), latest.getLicense() == null ? "Unknown" : latest.getLicense(), this.formatDevelopers(latest.getDevelopers())});
                FileUtils.writeStringToFile((File)new File(this.outputDirectory, "plugins/" + latest.getKey() + ".html"), (String)pluginInfoWidget);
            }
            System.out.println(latest.getName() + " : " + history.getAllVersions() + ", latest " + latest.getVersion());
        }
        return json;
    }

    private String formatDevelopers(List<Developer> developers) {
        if (developers == null) {
            return "Unknown";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < developers.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(developers.get(i).getName());
        }
        return sb.toString();
    }

    private String formatLink(String url) {
        return StringUtils.isBlank((String)url) ? "Unknown" : "<a href=\"" + url + "\" target=\"_top\">" + url + "</a>";
    }

    private JSONObject resolveSonar() throws Exception {
        Artifact artifact = this.artifactFactory.createArtifact("org.codehaus.sonar", "sonar-plugin-api", "LATEST", "compile", ARTIFACT_JAR_TYPE);
        List<ArtifactVersion> versions = this.filterSnapshots(this.metadataSource.retrieveAvailableVersions(artifact, this.localRepository, this.remoteRepositories));
        History<Sonar> history = new History<Sonar>();
        for (ArtifactVersion version : versions) {
            history.addArtifact(version, new Sonar(version.toString()));
        }
        return ((Sonar)history.latest()).toJsonObject();
    }

    private String getDownloadUrl(String groupId, String artifactId, String version) {
        return "http://repository.codehaus.org/" + StringUtils.replace((String)groupId, (String)".", (String)"/") + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "." + ARTIFACT_JAR_TYPE;
    }

    private History<Plugin> resolvePluginHistory(String id) throws Exception {
        String groupId = StringUtils.substringBefore((String)id, (String)":");
        String artifactId = StringUtils.substringAfter((String)id, (String)":");
        Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, "LATEST", "compile", ARTIFACT_JAR_TYPE);
        List<ArtifactVersion> versions = this.filterSnapshots(this.metadataSource.retrieveAvailableVersions(artifact, this.localRepository, this.remoteRepositories));
        History<Plugin> history = new History<Plugin>();
        for (ArtifactVersion version : versions) {
            Plugin plugin = Plugin.extractMetadata(this.resolve(artifact.getGroupId(), artifact.getArtifactId(), version.toString()));
            history.addArtifact(version, plugin);
            MavenProject project = this.mavenProjectBuilder.buildFromRepository(this.artifactFactory.createArtifact(groupId, artifactId, version.toString(), "compile", ARTIFACT_POM_TYPE), this.remoteRepositories, this.localRepository);
            if (plugin.getVersion() == null) {
                plugin.setKey(project.getArtifactId());
                plugin.setName(project.getName());
                plugin.setVersion(project.getVersion());
                String sonarVersion = "1.10";
                for (Dependency dependency : project.getDependencies()) {
                    if (!"sonar-plugin-api".equals(dependency.getArtifactId())) continue;
                    sonarVersion = dependency.getVersion();
                }
                plugin.setRequiredSonarVersion(sonarVersion);
                plugin.setHomepage(project.getUrl());
            }
            plugin.setDownloadUrl(this.getDownloadUrl(groupId, artifactId, plugin.getVersion()));
            if (project.getIssueManagement() != null) {
                plugin.setIssueTracker(project.getIssueManagement().getUrl());
            } else {
                System.out.println("Unknown Issue Management for " + plugin.getKey() + ":" + plugin.getVersion());
            }
            if (project.getScm() != null) {
                String scmUrl = project.getScm().getUrl();
                if (StringUtils.startsWith((String)scmUrl, (String)"scm:")) {
                    scmUrl = StringUtils.substringAfter((String)StringUtils.substringAfter((String)scmUrl, (String)":"), (String)":");
                }
                plugin.setSources(scmUrl);
            } else {
                System.out.println("Unknown SCM for " + plugin.getKey() + ":" + plugin.getVersion());
            }
            if (project.getLicenses() != null && project.getLicenses().size() > 0) {
                plugin.setLicense(((License)project.getLicenses().get(0)).getName());
            } else {
                System.out.println("Unknown License for " + plugin.getKey() + ":" + plugin.getVersion());
            }
            if (project.getDevelopers().size() > 0) {
                plugin.setDevelopers(project.getDevelopers());
                continue;
            }
            System.out.println("Unknown Developers for " + plugin.getKey() + ":" + plugin.getVersion());
        }
        return history;
    }

    private List<ArtifactVersion> filterSnapshots(List<ArtifactVersion> versions) {
        ArrayList<ArtifactVersion> result = new ArrayList<ArtifactVersion>();
        for (ArtifactVersion version : versions) {
            if ("SNAPSHOT".equalsIgnoreCase(version.getQualifier())) continue;
            result.add(version);
        }
        return result;
    }

    private File resolve(String groupId, String artifactId, String version) throws Exception {
        return this.resolve(groupId, artifactId, version, ARTIFACT_JAR_TYPE);
    }

    private File resolve(String groupId, String artifactId, String version, String type) throws Exception {
        Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, "compile", type);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setResolveTransitively(false).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories);
        this.artifactResolver.resolve(request);
        return artifact.getFile();
    }

    public static void main(String[] args) throws Exception {
        UpdateCenter updateCenter = new UpdateCenter();
        CmdLineParser p = new CmdLineParser((Object)updateCenter);
        p.parseArgument(args);
        updateCenter.run();
    }
}

