/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.api;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.maven.model.Developer;
import org.json.simple.JSONObject;
import org.sonar.updatecenter.api.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin
implements Versioned {
    private String key;
    private String name;
    private String description;
    private String version;
    private String downloadUrl;
    private String requiredSonarVersion;
    private String homepage;
    private long timestamp;
    private String pluginClass;
    private String issueTracker;
    private String sources;
    private String license;
    private List<Developer> developers;

    public Plugin(String pluginKey) {
        this.key = pluginKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getReleaseDate() {
        return new SimpleDateFormat("d MMM yyyy").format(new Date(this.timestamp));
    }

    private void setDate(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getRequiredSonarVersion() {
        return this.requiredSonarVersion;
    }

    public void setRequiredSonarVersion(String sonarVersion) {
        this.requiredSonarVersion = sonarVersion;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getIssueTracker() {
        return this.issueTracker;
    }

    public void setIssueTracker(String url) {
        this.issueTracker = url;
    }

    public String getSources() {
        return this.sources;
    }

    public void setSources(String sources) {
        this.sources = sources;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public List<Developer> getDevelopers() {
        return this.developers;
    }

    public void setDevelopers(List<Developer> developers) {
        this.developers = developers;
    }

    public JSONObject toJsonObject() {
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)this.getKey());
        obj.put((Object)"name", (Object)this.getName());
        obj.put((Object)"version", (Object)this.getVersion());
        obj.put((Object)"sonarVersion", (Object)this.getRequiredSonarVersion());
        if (this.getDownloadUrl() != null) {
            obj.put((Object)"downloadUrl", (Object)this.getDownloadUrl());
        }
        if (this.getHomepage() != null) {
            obj.put((Object)"homepage", (Object)this.getHomepage());
        }
        return obj;
    }

    public static Plugin extractMetadata(File file) throws IOException {
        JarFile jar = new JarFile(file);
        ZipEntry entry = jar.getEntry("META-INF/MANIFEST.MF");
        long timestamp = entry.getTime();
        Manifest manifest = jar.getManifest();
        jar.close();
        Attributes attributes = manifest.getMainAttributes();
        String pluginKey = attributes.getValue("Plugin-Key");
        Plugin plugin = new Plugin(pluginKey);
        plugin.setName(attributes.getValue("Plugin-Name"));
        plugin.setVersion(attributes.getValue("Plugin-Version"));
        plugin.setRequiredSonarVersion(attributes.getValue("Sonar-Version"));
        plugin.setHomepage(attributes.getValue("Plugin-Homepage"));
        plugin.setDate(timestamp);
        return plugin;
    }
}

