/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter;

import java.util.Collection;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.updatecenter.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Release
implements Comparable<Release> {
    private Version version;
    private String description;
    private String downloadUrl;
    private String changelogUrl;
    private SortedSet<Version> requiredSonarVersions = new TreeSet<Version>();
    private Date date;

    public Release() {
    }

    public Release(Version version) {
        this.version = version;
    }

    public Release(String version) {
        this.version = new Version(version);
    }

    public Version getVersion() {
        return this.version;
    }

    public Release setVersion(Version version) {
        this.version = version;
        return this;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public Release setDownloadUrl(String s) {
        this.downloadUrl = s;
        return this;
    }

    public String getFilename() {
        return StringUtils.substringAfterLast((String)this.downloadUrl, (String)"/");
    }

    public SortedSet<Version> getRequiredSonarVersions() {
        return this.requiredSonarVersions;
    }

    public boolean supportSonarVersion(Version version) {
        return this.requiredSonarVersions.contains(version);
    }

    public Release addRequiredSonarVersion(Version v) {
        this.requiredSonarVersions.add(v);
        return this;
    }

    public Release addRequiredSonarVersions(Collection<Version> v) {
        this.requiredSonarVersions.addAll(v);
        return this;
    }

    public Version getLastRequiredSonarVersion() {
        if (this.requiredSonarVersions != null && !this.requiredSonarVersions.isEmpty()) {
            return this.requiredSonarVersions.last();
        }
        return null;
    }

    public Date getDate() {
        return this.date;
    }

    public Release setDate(Date date) {
        this.date = date;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getChangelogUrl() {
        return this.changelogUrl;
    }

    public void setChangelogUrl(String changelogUrl) {
        this.changelogUrl = changelogUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Release that = (Release)o;
        return this.version.equals(that.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("version", (Object)this.version).append("downloadUrl", (Object)this.downloadUrl).append("changelogUrl", (Object)this.changelogUrl).append("description", (Object)this.description).toString();
    }

    @Override
    public int compareTo(Release o) {
        return this.getVersion().compareTo(o.getVersion());
    }
}

