/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter;

import org.sonar.updatecenter.Release;
import org.sonar.updatecenter.Version;

public final class Update {
    private Status status;
    private Release release;

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Release getRelease() {
        return this.release;
    }

    public void setRelease(Release release) {
        this.release = release;
    }

    public static Update createForPluginRelease(Release pluginRelease, Version sonarVersion) {
        Update update = new Update();
        update.setRelease(pluginRelease);
        update.setStatus(Status.INCOMPATIBLE);
        if (pluginRelease.supportSonarVersion(sonarVersion)) {
            update.setStatus(Status.COMPATIBLE);
        } else {
            for (Version requiredSonarVersion : pluginRelease.getRequiredSonarVersions()) {
                if (requiredSonarVersion.compareTo(sonarVersion) <= 0) continue;
                update.setStatus(Status.REQUIRE_SONAR_UPGRADE);
                break;
            }
        }
        return update;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        COMPATIBLE,
        INCOMPATIBLE,
        REQUIRE_SONAR_UPGRADE;

    }
}

