/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter;

import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private String major = Version.normalizePart("0");
    private String minor = Version.normalizePart("0");
    private String patch = Version.normalizePart("0");
    private String patch2 = Version.normalizePart("0");
    private String name;

    public Version(String version) {
        this.name = StringUtils.trimToEmpty((String)version);
        String[] split = StringUtils.split((String)this.name, (char)'.');
        if (split.length >= 1) {
            this.major = Version.normalizePart(split[0]);
        }
        if (split.length >= 2) {
            this.minor = Version.normalizePart(split[1]);
        }
        if (split.length >= 3) {
            this.patch = Version.normalizePart(split[2]);
        }
        if (split.length >= 4) {
            this.patch2 = Version.normalizePart(split[3]);
        }
    }

    private static String normalizePart(String part) {
        return StringUtils.leftPad((String)part, (int)4, (char)'0');
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getPatch() {
        return this.patch;
    }

    public String getPatch2() {
        return this.patch2;
    }

    public String getVersion() {
        return this.name;
    }

    public boolean isRelease() {
        return StringUtils.isNumeric((String)this.major) && (StringUtils.isNumeric((String)this.minor) || StringUtils.contains((String)this.minor, (String)"GA")) && StringUtils.isNumeric((String)this.patch) && StringUtils.isNumeric((String)this.patch2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (!this.major.equals(version.major)) {
            return false;
        }
        if (!this.minor.equals(version.minor)) {
            return false;
        }
        if (!this.patch.equals(version.patch)) {
            return false;
        }
        return this.patch2.equals(version.patch2);
    }

    public int hashCode() {
        int result = this.major.hashCode();
        result = 31 * result + this.minor.hashCode();
        result = 31 * result + this.patch.hashCode();
        result = 31 * result + this.patch2.hashCode();
        return result;
    }

    @Override
    public int compareTo(Version other) {
        int c = this.major.compareTo(other.major);
        if (c == 0 && (c = this.minor.compareTo(other.minor)) == 0 && (c = this.patch.compareTo(other.patch)) == 0) {
            c = this.patch2.compareTo(other.patch2);
        }
        return c;
    }

    public String toString() {
        return this.name;
    }

    public static Version create(String version) {
        return new Version(version);
    }
}

