/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.lexer;

import com.sonar.sslr.api.Token;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HasTokenValueMatcher
extends BaseMatcher<List<Token>> {
    private final String tokenValue;
    private final boolean originalValue;

    HasTokenValueMatcher(String tokenValue) {
        this(tokenValue, false);
    }

    HasTokenValueMatcher(String tokenValue, boolean originalValue) {
        this.tokenValue = tokenValue;
        this.originalValue = originalValue;
    }

    public boolean matches(Object obj) {
        if (!(obj instanceof List)) {
            return false;
        }
        List tokens = (List)obj;
        for (Token token : tokens) {
            String value = this.originalValue ? token.getOriginalValue() : token.getValue();
            if (!value.equals(this.tokenValue)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description desc) {
        if (this.originalValue) {
            desc.appendText("OriginalToken('" + this.tokenValue + "')");
        } else {
            desc.appendText("Token('" + this.tokenValue + "')");
        }
    }
}

