/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.miniC;

import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.test.miniC.MiniCColorizer;
import com.sonar.sslr.test.miniC.MiniCParser;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.sonar.colorizer.Tokenizer;
import org.sonar.sslr.toolkit.AbstractConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationProperty;
import org.sonar.sslr.toolkit.Toolkit;
import org.sonar.sslr.toolkit.ValidationCallback;

public final class MiniCToolkit {
    private MiniCToolkit() {
    }

    public static void main(String[] args) {
        Toolkit toolkit = new Toolkit("SonarSource : MiniC : Toolkit", (ConfigurationModel)new MiniCConfigurationModel());
        toolkit.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MiniCConfigurationModel
    extends AbstractConfigurationModel {
        private final ConfigurationProperty charsetProperty = new ConfigurationProperty("Charset", "Charset used when opening files.", "UTF-8", new ValidationCallback(){

            public String validate(String newValueCandidate) {
                try {
                    Charset.forName(newValueCandidate);
                    return "";
                }
                catch (IllegalCharsetNameException e) {
                    return "Illegal charset name: " + newValueCandidate;
                }
                catch (UnsupportedCharsetException e) {
                    return "Unsupported charset: " + newValueCandidate;
                }
            }
        });

        MiniCConfigurationModel() {
        }

        public List<ConfigurationProperty> getProperties() {
            return ImmutableList.of((Object)this.charsetProperty);
        }

        public Parser<? extends Grammar> doGetParser() {
            this.updateConfiguration();
            return MiniCParser.create(new ParsingEventListener[0]);
        }

        public List<Tokenizer> doGetTokenizers() {
            this.updateConfiguration();
            return MiniCColorizer.getTokenizers();
        }

        private void updateConfiguration() {
        }
    }
}

