/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.parser;

import com.sonar.sslr.impl.BacktrackingEvent;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.ParsingStackTrace;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.matcher.Matcher;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MatchMatcher
extends BaseMatcher<Matcher> {
    private final String sourceCode;
    private final Lexer lexer;
    private String parsingStackTrace;
    private Matcher matcher;

    public MatchMatcher(String sourceCode, Lexer lexer) {
        this.sourceCode = sourceCode;
        this.lexer = lexer;
    }

    public boolean matches(Object obj) {
        if (!(obj instanceof Matcher)) {
            return false;
        }
        this.matcher = (Matcher)obj;
        ParsingState parsingState = new ParsingState(this.lexer.lex(this.sourceCode));
        try {
            this.matcher.match(parsingState);
            return true;
        }
        catch (BacktrackingEvent e) {
            this.parsingStackTrace = ParsingStackTrace.generateFullStackTrace((ParsingState)parsingState);
            return false;
        }
    }

    public void describeTo(Description desc) {
        if (this.parsingStackTrace != null) {
            desc.appendText("The matcher '" + this.matcher + "' doesn't match the beginning of '" + this.sourceCode + "'.\n");
            desc.appendText("Parsing stack trace : " + this.parsingStackTrace);
        } else {
            desc.appendText("The matcher '" + this.matcher + "' hasn't matched the overall expression '" + this.sourceCode + "'.\n");
        }
    }
}

