/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.parser;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ExtendedStackTrace;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.sonar.sslr.tests.ParsingResultComparisonFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParseMatcher
extends BaseMatcher<Parser> {
    private final String sourceCode;

    public ParseMatcher(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public boolean matches(Object obj) {
        if (!(obj instanceof Parser)) {
            return false;
        }
        Parser actual = (Parser)obj;
        if (actual.getRootRule() == null) {
            throw new IllegalStateException("The root rule of the parser is null. No grammar decorator seems to be activated.");
        }
        Parser parser = Parser.builder((Parser)actual).setExtendedStackTrace(new ExtendedStackTrace()).build();
        parser.setRootRule((Rule)actual.getRootRule());
        String expected = "Rule '" + actual.getRootRule().getRule().getName() + "' should match:\n" + this.sourceCode;
        try {
            parser.parse(this.sourceCode);
        }
        catch (RecognitionException e) {
            throw new ParsingResultComparisonFailure(expected, e.getMessage());
        }
        if (parser.getParsingState().hasNextToken() && parser.getParsingState().readToken(parser.getParsingState().lexerIndex).getType() != GenericTokenType.EOF) {
            throw new ParsingResultComparisonFailure(expected, "Not all tokens have been consumed");
        }
        return true;
    }

    public void describeTo(Description desc) {
        desc.appendText("Tokens haven't been all consumed '" + this.sourceCode + "'");
    }
}

