/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.tests;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ExtendedStackTrace;
import org.fest.assertions.GenericAssert;
import org.sonar.sslr.tests.Assertions;
import org.sonar.sslr.tests.ParsingResultComparisonFailure;
import org.sonar.sslr.tests.RuleAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserAssert
extends GenericAssert<ParserAssert, Parser> {
    public ParserAssert(Parser actual) {
        super(ParserAssert.class, (Object)actual);
    }

    public ParserAssert matches(String input) {
        this.isNotNull();
        this.hasRootRule();
        Parser parser = Parser.builder((Parser)((Parser)this.actual)).setExtendedStackTrace(new ExtendedStackTrace()).build();
        parser.setRootRule((Rule)((Parser)this.actual).getRootRule());
        String expected = "Rule '" + this.getRuleName() + "' should match:\n" + input;
        try {
            parser.parse(input);
        }
        catch (RecognitionException e) {
            String actual = e.getMessage();
            throw new ParsingResultComparisonFailure(expected, actual);
        }
        if (!ParserAssert.isAllTokensConsumed(parser)) {
            String actual = "Not all tokens have been consumed";
            throw new ParsingResultComparisonFailure(expected, actual);
        }
        return this;
    }

    public ParserAssert notMatches(String input) {
        this.isNotNull();
        this.hasRootRule();
        Parser parser = (Parser)this.actual;
        try {
            parser.parse(input);
        }
        catch (RecognitionException e) {
            return this;
        }
        if (ParserAssert.isAllTokensConsumed(parser)) {
            throw new AssertionError((Object)("Rule '" + this.getRuleName() + "' should not match:\n" + input));
        }
        return this;
    }

    private void hasRootRule() {
        ((RuleAssert)((Object)Assertions.assertThat((Rule)((Parser)this.actual).getRootRule()).overridingErrorMessage("Root rule of the parser should not be null"))).isNotNull();
    }

    private static boolean isAllTokensConsumed(Parser parser) {
        return !parser.getParsingState().hasNextToken() || parser.getParsingState().readToken(parser.getParsingState().lexerIndex).getType() == GenericTokenType.EOF;
    }

    private String getRuleName() {
        return ((Parser)this.actual).getRootRule().getRule().getName();
    }
}

