/*
 * SonarSource Language Recognizer
 * Copyright (C) 2010 SonarSource
 * dev@sonar.codehaus.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.sslr.tests;

import org.junit.ComparisonFailure;

/**
 * <p>This class is not intended to be instantiated or subclassed by clients.</p>
 *
 * @since 1.16
 */
public class ParsingResultComparisonFailure extends ComparisonFailure {

  private final String message;

  public ParsingResultComparisonFailure(String expected, String actual) {
    this(expected + '\n' + actual, expected, actual);
  }

  public ParsingResultComparisonFailure(String message, String expected, String actual) {
    super(message, expected, actual);
    this.message = message;
  }

  @Override
  public String getMessage() {
    return message;
  }

}
