/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.tx;

import com.arjuna.ats.internal.jta.transaction.jts.AtomicTransaction;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.ORBManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.Unavailable;

public class JtsTransactionImple
extends TransactionImple {
    private static final Logger log = LogManager.getLogger(JtsTransactionImple.class);
    private static TransactionManager tm;
    private static final String IORTag = "IOR";

    public JtsTransactionImple(ControlWrapper wrapper) {
        super(new AtomicTransaction(wrapper));
    }

    public static boolean hasTransaction() {
        if (JtsTransactionImple.hasTransactionManager()) {
            try {
                return tm.getTransaction() != null;
            }
            catch (javax.transaction.SystemException e) {
                return false;
            }
        }
        throw new RuntimeException("UNEXPECTED CODE BRANCH IN THE HACK");
    }

    private static boolean hasTransactionManager() {
        try {
            return JtsTransactionImple.getTransactionManager() != null;
        }
        catch (NamingException e) {
            return false;
        }
    }

    public static void resume(String ior) throws InvalidTransactionException, IllegalStateException, javax.transaction.SystemException {
        log.debug((java.lang.Object)"resume control");
        if (!JtsTransactionImple.hasTransactionManager()) {
            throw new RuntimeException("UNEXPECTED CODE BRANCH IN THE HACK");
        }
        Transaction tx = JtsTransactionImple.controlToTx(ior);
        tm.resume(tx);
    }

    public static void suspend() throws javax.transaction.SystemException {
        log.debug((java.lang.Object)"suspend");
        if (!JtsTransactionImple.hasTransactionManager()) {
            throw new RuntimeException("UNEXPECTED CODE BRANCH IN THE HACK");
        }
        log.debug((java.lang.Object)"suspending current");
        tm.suspend();
    }

    private static Transaction controlToTx(String ior) {
        log.trace((java.lang.Object)("controlToTx: ior: " + ior));
        ControlWrapper cw = JtsTransactionImple.createControlWrapper(ior);
        TransactionImple tx = (TransactionImple)TransactionImple.getTransactions().get(cw.get_uid());
        if (tx == null) {
            log.trace((java.lang.Object)("controlToTx: creating a new tx - wrapper: " + cw));
            tx = new JtsTransactionImple(cw);
            log.trace((java.lang.Object)"Created tx");
            JtsTransactionImple.putTransaction((TransactionImple)tx);
            log.trace((java.lang.Object)"put tx");
        }
        log.trace((java.lang.Object)"return tx");
        return tx;
    }

    private static synchronized TransactionManager getTransactionManager() throws NamingException {
        if (tm == null) {
            InitialContext ctx = new InitialContext();
            tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
        }
        return tm;
    }

    public static String getTransactionIOR() throws SystemException, javax.transaction.SystemException, Unavailable {
        log.debug((java.lang.Object)"getTransactionIOR");
        if (JtsTransactionImple.hasTransaction()) {
            log.debug((java.lang.Object)"have tx mgr");
            Transaction tx = tm.getTransaction();
            log.debug((java.lang.Object)"have arjuna tx");
            TransactionImple atx = (TransactionImple)tx;
            ControlWrapper cw = atx.getControlWrapper();
            log.debug((java.lang.Object)"lookup control");
            Control c = cw.get_control();
            String ior = ORBManager.getORB().orb().object_to_string((Object)c);
            log.debug((java.lang.Object)("getTransactionIOR: ior: " + ior));
            return ior;
        }
        return null;
    }

    private static ControlWrapper createControlWrapper(String ior) {
        Object obj = ORBManager.getORB().orb().string_to_object(ior);
        Control control = ControlHelper.narrow((Object)obj);
        if (control == null) {
            log.warn((java.lang.Object)"createProxy: ior not a control");
        }
        return new ControlWrapper(control);
    }
}

