/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stomp.jms;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.jms.XAConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ServerSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.stomp.StompHandler;
import org.codehaus.stomp.StompHandlerFactory;
import org.codehaus.stomp.jms.ProtocolConverter;
import org.codehaus.stomp.tcp.TcpTransportServer;
import org.codehaus.stomp.util.ServiceSupport;

public class StompConnect
extends ServiceSupport
implements StompHandlerFactory {
    private static final transient Log log = LogFactory.getLog(StompConnect.class);
    private XAConnectionFactory connectionFactory;
    private String uri = "tcp://localhost:61613";
    private URI location;
    private ServerSocketFactory serverSocketFactory;
    private TcpTransportServer tcpServer;
    private InitialContext initialContext;
    private String jndiName = "ConnectionFactory";
    private Hashtable jndiEnvironment = new Hashtable();

    public StompConnect() {
    }

    public StompConnect(XAConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public StompHandler createStompHandler(StompHandler outputHandler) throws NamingException {
        XAConnectionFactory factory = this.getConnectionFactory();
        if (factory == null) {
            throw new IllegalArgumentException("No ConnectionFactory is configured!");
        }
        return new ProtocolConverter(factory, outputHandler);
    }

    public void join() throws IOException, URISyntaxException, InterruptedException {
        this.getTcpServer().join();
    }

    public XAConnectionFactory getConnectionFactory() throws NamingException {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(XAConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public URI getLocation() throws URISyntaxException {
        if (this.location == null) {
            this.location = new URI(this.uri);
        }
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public ServerSocketFactory getServerSocketFactory() {
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        return this.serverSocketFactory;
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public TcpTransportServer getTcpServer() throws IOException, URISyntaxException {
        if (this.tcpServer == null) {
            this.tcpServer = this.createTcpServer();
        }
        return this.tcpServer;
    }

    public void setTcpServer(TcpTransportServer tcpServer) {
        this.tcpServer = tcpServer;
    }

    public InitialContext getInitialContext() throws NamingException {
        if (this.initialContext == null) {
            this.initialContext = new InitialContext(this.jndiEnvironment);
        }
        return this.initialContext;
    }

    public void setInitialContext(InitialContext initialContext) {
        this.initialContext = initialContext;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Hashtable getJndiEnvironment() {
        return this.jndiEnvironment;
    }

    public void setJndiEnvironment(Hashtable jndiEnvironment) {
        this.jndiEnvironment = jndiEnvironment;
    }

    protected void doStart() throws Exception {
        XAConnectionFactory factory = this.getConnectionFactory();
        if (factory == null) {
            throw new IllegalArgumentException("No ConnectionFactory has been configured!");
        }
        this.getTcpServer().start();
    }

    protected void doStop() throws Exception {
        this.getTcpServer().stop();
    }

    protected TcpTransportServer createTcpServer() throws IOException, URISyntaxException {
        return new TcpTransportServer(this, this.getLocation(), this.getServerSocketFactory());
    }

    protected XAConnectionFactory createConnectionFactory() throws NamingException {
        String name = this.getJndiName();
        log.info((Object)("Looking up name: " + name + " in JNDI InitialContext for JMS ConnectionFactory"));
        Object value = this.getInitialContext().lookup(name);
        if (value == null) {
            throw new IllegalArgumentException("No ConnectionFactory object is available in JNDI at name: " + name);
        }
        if (value instanceof XAConnectionFactory) {
            return (XAConnectionFactory)value;
        }
        throw new IllegalArgumentException("The object in JNDI at name: " + name + " cannot be cast to ConnectionFactory. " + "Either a JNDI configuration issue or you have multiple JMS API jars on your classpath. " + "Actual Object was: " + value);
    }
}

