/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xdas4j.logger;

import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.codehaus.xdas4j.datamodel.XDASEvent;

public class XDASJSONLayout
extends Layout {
    public void activateOptions() {
    }

    public String format(LoggingEvent event) {
        XDASEvent evt = (XDASEvent)event.getMessage();
        return "{" + this.subAppend(evt) + "}";
    }

    private String append(String start, String end) {
        if (start == null) {
            return end;
        }
        return start + " ," + end;
    }

    private String subAppend(Object o) {
        Method[] eventMethods;
        String log = null;
        for (Method m : eventMethods = o.getClass().getMethods()) {
            if (!m.getName().startsWith("get") || m.getName().contains("Instance") || m.getName().contains("Class")) continue;
            Object attributeData = null;
            try {
                attributeData = m.invoke(o, new Object[0]);
            }
            catch (Throwable e) {
                LogLog.error((String)("Unable to extract XDAS " + m.getName() + "attribute from " + o.getClass()), (Throwable)e);
            }
            if (attributeData == null) continue;
            if (!attributeData.getClass().getName().startsWith("org.codehaus.xdas4j.datamodel") || attributeData instanceof Enum) {
                if (attributeData instanceof Collection) {
                    Collection attributeCollection = (Collection)attributeData;
                    String collectionString = null;
                    for (Object collectionItem : attributeCollection) {
                        collectionString = this.append(collectionString, "{" + this.subAppend(collectionItem) + "}");
                    }
                    log = this.append(log, "\"" + m.getName().substring(3) + "\": [" + collectionString + "]");
                    continue;
                }
                log = this.append(log, "\"" + m.getName().substring(3) + "\": \"" + attributeData + "\"");
                continue;
            }
            log = this.append(log, "\"" + attributeData.getClass().getSimpleName() + "\": {" + this.subAppend(attributeData) + "}");
        }
        return log;
    }

    public boolean ignoresThrowable() {
        return true;
    }
}

